/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.xml.elements;

import java.awt.Point;
import java.text.MessageFormat;
import java.text.ParseException;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLUtil;
import org.w3c.dom.Element;

public abstract class AbstractTagHandler {
    private Element element;
    private IXMLTestCase testCase;

    public AbstractTagHandler(Element element, IXMLTestCase iXMLTestCase) {
        this.element = element;
        this.testCase = iXMLTestCase;
    }

    public Element getElement() {
        return this.element;
    }

    public IXMLTestCase getTestCase() {
        return this.testCase;
    }

    protected void validateElement() throws XMLException {
        if (this.element == null) {
            throw new XMLException("Element could not be found.");
        }
    }

    public abstract void processElement() throws Exception;

    protected void checkElementTagName(String string) throws XMLException {
        if (!string.equals(this.element.getTagName())) {
            throw new XMLException("Cannot process " + this.getElement().getTagName() + " node, expected '" + string + "'");
        }
    }

    protected void checkRequiredAttribute(String string) throws XMLException {
        String string2 = XMLUtil.getAttribute(this.element, string);
        if (string2 == null) {
            throw new XMLException("Missing the required attribute: " + string + " in element: " + this.element.getNodeName());
        }
    }

    protected void checkAtLeastOneRequiredAttribute(Element element, String[] stringArray) throws XMLException {
        String string;
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            string = XMLUtil.getAttribute(element, stringArray[n2]);
            if (string != null) {
                ++n;
            }
            ++n2;
        }
        if (n == 0) {
            string = "";
            int n3 = 0;
            while (n3 < stringArray.length) {
                string = MessageFormat.format("{0} {1}", string, stringArray[n3]);
                ++n3;
            }
            throw new XMLException(element.getNodeName() + " is missing one of the required attributes: " + string);
        }
    }

    protected void checkOneRequiredAttribute(Element element, String[] stringArray) throws XMLException {
        int n = 0;
        if (stringArray != null) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (XMLUtil.getAttribute(element, stringArray[n2]) != null) {
                    ++n;
                }
                ++n2;
            }
        }
        if (n == 0) {
            String string = "";
            int n3 = 0;
            while (n3 < stringArray.length) {
                string = MessageFormat.format("{0} {1}", string, stringArray[n3]);
                ++n3;
            }
            throw new XMLException(element.getNodeName() + " is missing one of the required attributes: " + string);
        }
        if (n > 1) {
            String string = "";
            int n4 = 0;
            while (n4 < stringArray.length) {
                string = MessageFormat.format("{0} {1}", string, stringArray[n4]);
                ++n4;
            }
            throw new XMLException("Too many attributes of:" + string);
        }
    }

    private boolean isAvailable(String string) {
        return this.getString(string) != null;
    }

    protected long getLong(String string, long l) throws NumberFormatException {
        return this.isAvailable(string) ? Long.parseLong(this.getString(string)) : l;
    }

    protected int getInt(String string, int n) throws NumberFormatException {
        return this.isAvailable(string) ? Integer.parseInt(this.getString(string)) : n;
    }

    protected boolean getBoolean(String string) {
        Boolean bl = new Boolean(this.getString(string));
        return bl;
    }

    protected Point getPoint(String string, Point point) throws ParseException {
        if (!this.isAvailable(string)) {
            return point;
        }
        String string2 = this.getString(string);
        MessageFormat messageFormat = new MessageFormat("{0},{1}");
        Object[] objectArray = messageFormat.parse(string2);
        int n = Integer.parseInt((String)objectArray[0]);
        int n2 = Integer.parseInt((String)objectArray[1]);
        return new Point(n, n2);
    }

    protected String getString(String string) {
        return XMLUtil.getAttribute(this.getElement(), string);
    }
}

