/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.xml;

import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.JFCTestHelper;
import junit.extensions.jfcunit.RobotTestHelper;
import junit.extensions.jfcunit.xml.JFCXMLConstants;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLTagResourceBundle;
import junit.extensions.xml.XMLUtil;
import junit.extensions.xml.elements.AbstractTagHandler;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TestTagHandler
extends AbstractTagHandler
implements JFCXMLConstants {
    public TestTagHandler(Element element, IXMLTestCase iXMLTestCase) {
        super(element, iXMLTestCase);
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkElementTagName("test");
    }

    public void processElement() throws Exception {
        this.validateElement();
        IXMLTestCase iXMLTestCase = this.getTestCase();
        iXMLTestCase.clearFoundObjects();
        Element element = this.getElement();
        if (iXMLTestCase instanceof JFCTestCase) {
            boolean bl = XMLUtil.getBooleanAttributeValue(element, "robot");
            if (bl) {
                ((JFCTestCase)((Object)iXMLTestCase)).setHelper(new RobotTestHelper());
            } else {
                ((JFCTestCase)((Object)iXMLTestCase)).setHelper(new JFCTestHelper());
            }
        }
        iXMLTestCase.setName(this.getName());
        NodeList nodeList = this.getElement().getChildNodes();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (nodeList.item(n) instanceof Element) {
                Element element2 = (Element)nodeList.item(n);
                String string = element2.getTagName();
                XMLTagResourceBundle.getTagHandler(element2, this.getTestCase(), string).processElement();
            }
            ++n;
        }
    }

    private String getName() {
        return this.getString("name");
    }
}

