/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.finder;

import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.Arrays;
import javax.swing.Icon;

public class IconMatcher {
    private Icon icon = null;
    private int[] iconData = null;
    private int icw = 0;
    private int ich = 0;
    private int incr = 1;
    private int size = 0;

    public IconMatcher(Icon icon) throws InterruptedException {
        this.icon = icon;
        if (icon != null) {
            this.iconData = this.iconToArray(icon);
            this.icw = icon.getIconWidth();
            this.ich = icon.getIconHeight();
            this.size = this.icw * this.ich;
            int n = Math.min(this.icw, this.ich);
            this.incr = n > 32 ? n / 8 : n / 4;
        }
    }

    private int[] iconToArray(Icon icon) throws InterruptedException {
        int n = icon.getIconWidth();
        int n2 = icon.getIconHeight();
        int[] nArray = new int[n * n2];
        BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
        icon.paintIcon(null, bufferedImage.getGraphics(), 0, 0);
        PixelGrabber pixelGrabber = new PixelGrabber(bufferedImage, 0, 0, n, n2, nArray, 0, n);
        pixelGrabber.grabPixels();
        return nArray;
    }

    public boolean matches(Icon icon) {
        if (this.icon == null) {
            return true;
        }
        if (icon == null) {
            return false;
        }
        if (this.icw != icon.getIconWidth() || this.ich != icon.getIconHeight()) {
            return false;
        }
        int[] nArray = null;
        try {
            nArray = this.iconToArray(icon);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (nArray == null || this.iconData.length != nArray.length) {
            return false;
        }
        int n = 0;
        while (n < this.size) {
            if (this.iconData[n] != nArray[n]) {
                return false;
            }
            n += this.incr;
        }
        return Arrays.equals(this.iconData, nArray);
    }
}

