/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.eventdata.AbstractKeyEventData;
import junit.extensions.jfcunit.keyboard.JFCKeyStroke;
import junit.extensions.jfcunit.keyboard.KeyMapping;

public class StringEventData
extends AbstractKeyEventData {
    private String string = null;
    private Component comp = null;

    public StringEventData() {
        this.setValid(false);
    }

    public StringEventData(JFCTestCase jFCTestCase, Component component, String string) {
        this(jFCTestCase, component, string, 0, 300L);
    }

    public StringEventData(JFCTestCase jFCTestCase, Component component, String string, long l) {
        this(jFCTestCase, component, string, 0, l);
    }

    public StringEventData(JFCTestCase jFCTestCase, Component component, String string, int n, long l) {
        this.setTestCase(jFCTestCase);
        this.setSource(component);
        this.setString(string);
        this.setModifiers(n);
        this.setSleepTime(l);
        this.setValid(true);
    }

    public void setString(String string) {
        this.string = string;
        this.setupKeyStrokes();
    }

    public void setModifiers(int n) {
        super.setModifiers(n);
        this.setupKeyStrokes();
    }

    private void setupKeyStrokes() {
        KeyMapping keyMapping = TestHelper.getKeyMapping();
        this.clearKeyStrokes();
        int n = 0;
        while (n < this.string.length()) {
            JFCKeyStroke[] jFCKeyStrokeArray = keyMapping.getKeyStrokes(this.string.charAt(n));
            this.addKeyStrokes(jFCKeyStrokeArray);
            ++n;
        }
        this.applyModifier(this.getModifiers());
    }

    public String getString() {
        return this.string;
    }

    public void setSource(Component component) {
        this.comp = component;
    }

    public Component getSource() {
        return this.comp;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public String toString() {
        return "StringEventData:" + this.getString() + " on " + this.getComponent() + " " + this.getModifiers() + " " + this.getSleepTime();
    }

    public boolean consume(AWTEvent aWTEvent) {
        if (super.consume(aWTEvent)) {
            return true;
        }
        this.setSource((Component)aWTEvent.getSource());
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isValid()) {
            stringBuffer.append(this.getString());
        }
        stringBuffer.append(((KeyEvent)aWTEvent).getKeyChar());
        this.setString(stringBuffer.toString());
        this.setValid(true);
        return true;
    }

    public boolean canConsume(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof KeyEvent)) {
            return false;
        }
        return super.canConsume(aWTEvent) && (this.isMetaChar(((KeyEvent)aWTEvent).getKeyCode()) || ((KeyEvent)aWTEvent).getKeyChar() != '\uffff');
    }
}

