/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.eventdata.AbstractKeyEventData;
import junit.extensions.jfcunit.keyboard.JFCKeyStroke;
import junit.extensions.jfcunit.keyboard.KeyMapping;

public class KeyEventData
extends AbstractKeyEventData {
    private int keyCode = 0;
    private Component comp = null;

    public KeyEventData() {
    }

    public KeyEventData(JFCTestCase jFCTestCase, Component component, int n) {
        this(jFCTestCase, component, n, 0, 300L);
    }

    public KeyEventData(JFCTestCase jFCTestCase, Component component, int n, long l) {
        this(jFCTestCase, component, n, 0, l);
    }

    public KeyEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, long l) {
        this.setTestCase(jFCTestCase);
        this.setSource(component);
        this.setModifiers(n2);
        this.setKeyCode(n);
        this.setSleepTime(l);
        this.setValid(true);
    }

    public void setKeyCode(int n) {
        this.keyCode = n;
        this.setupKeyStrokes();
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public void setModifiers(int n) {
        super.setModifiers(n);
        this.setupKeyStrokes();
    }

    private void setupKeyStrokes() {
        KeyMapping keyMapping = TestHelper.getKeyMapping();
        this.clearKeyStrokes();
        JFCKeyStroke[] jFCKeyStrokeArray = keyMapping.getKeyStrokes(this.keyCode);
        this.addKeyStrokes(jFCKeyStrokeArray);
        this.applyModifier(this.getModifiers());
    }

    public void setSource(Component component) {
        this.comp = component;
    }

    public Component getSource() {
        return this.comp;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public String toString() {
        return "KeyEventData:" + this.keyCode + " on " + this.getSource() + " " + this.getModifiers() + " " + this.getSleepTime();
    }

    public boolean consume(AWTEvent aWTEvent) {
        if (super.consume(aWTEvent)) {
            return true;
        }
        this.setSource((Component)aWTEvent.getSource());
        this.setModifiers(((KeyEvent)aWTEvent).getModifiers());
        this.setKeyCode(((KeyEvent)aWTEvent).getKeyCode());
        this.setValid(true);
        return true;
    }

    public boolean canConsume(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof KeyEvent)) {
            return false;
        }
        return super.canConsume(aWTEvent) && ((KeyEvent)aWTEvent).getKeyChar() == '\uffff';
    }
}

