/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;

public class JTreeMouseEventData
extends AbstractMouseEventData {
    private JTree tree;
    private TreePath treePath;
    private String nodeValue;

    public JTreeMouseEventData() {
        this.setValid(false);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, TreePath treePath, int n) {
        this(jFCTestCase, jTree, treePath, n, 300L);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, String string, int n) {
        this(jFCTestCase, jTree, string, n, 300L);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, TreePath treePath, int n, long l) {
        this(jFCTestCase, jTree, treePath, n, false, l);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, String string, int n, long l) {
        this(jFCTestCase, jTree, string, n, false, l);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, TreePath treePath, int n, boolean bl) {
        this(jFCTestCase, jTree, treePath, n, bl, 300L);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, String string, int n, boolean bl) {
        this(jFCTestCase, jTree, string, n, bl, 300L);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, TreePath treePath, int n, boolean bl, long l) {
        this(jFCTestCase, jTree, treePath, n, AbstractMouseEventData.getDefaultModifiers(bl), bl, l);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, String string, int n, boolean bl, long l) {
        this(jFCTestCase, jTree, string, n, AbstractMouseEventData.getDefaultModifiers(bl), bl, l);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, TreePath treePath, int n, int n2, boolean bl, long l) {
        this(jFCTestCase, jTree, treePath, n, n2, bl, l, 0, null);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, String string, int n, int n2, boolean bl, long l) {
        this(jFCTestCase, jTree, string, n, n2, bl, l, 0, null);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, TreePath treePath, int n, int n2, boolean bl, long l, int n3) {
        this(jFCTestCase, jTree, treePath, n, n2, bl, l, n3, null);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, String string, int n, int n2, boolean bl, long l, int n3) {
        this(jFCTestCase, jTree, string, n, n2, bl, l, n3, null);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, TreePath treePath, int n, int n2, boolean bl, long l, Point point) {
        this(jFCTestCase, jTree, treePath, n, n2, bl, l, 12, point);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, String string, int n, int n2, boolean bl, long l, Point point) {
        this(jFCTestCase, jTree, string, n, n2, bl, l, 12, point);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, TreePath treePath, int n, int n2, boolean bl, long l, int n3, Point point) {
        this.setTestCase(jFCTestCase);
        this.setSource(jTree);
        this.setNumberOfClicks(n);
        this.setModifiers(n2);
        this.setPopupTrigger(bl);
        this.setTreePath(treePath);
        this.setSleepTime(l);
        this.setPosition(n3);
        this.setReferencePoint(point);
        this.setValid(true);
    }

    public JTreeMouseEventData(JFCTestCase jFCTestCase, JTree jTree, String string, int n, int n2, boolean bl, long l, int n3, Point point) {
        this.setTestCase(jFCTestCase);
        this.setSource(jTree);
        this.setNumberOfClicks(n);
        this.setModifiers(n2);
        this.setPopupTrigger(bl);
        this.setNodeValue(string);
        this.setSleepTime(l);
        this.setPosition(n3);
        this.setReferencePoint(point);
        this.setValid(true);
    }

    public void setSource(JTree jTree) {
        this.tree = jTree;
    }

    public JTree getSource() {
        return this.tree;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public void setTreePath(TreePath treePath) {
        this.treePath = treePath;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public void setNodeValue(String string) {
        this.nodeValue = string;
    }

    public String getNodeValue() {
        return this.nodeValue;
    }

    public boolean prepareComponent() {
        Cloneable cloneable;
        TreePath treePath;
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        this.tree.updateUI();
        JFCTestCase jFCTestCase = this.getTestCase();
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        if ((treePath = this.getTreePath()) == null) {
            treePath = new TreePath(this.buildPath(this.getNode(this.tree, this.getNodeValue())));
        }
        if (treePath == null) {
            return false;
        }
        this.tree.setSelectionPath(treePath);
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        Rectangle rectangle = this.tree.getPathBounds(treePath);
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        Point point = this.calculatePoint(rectangle);
        if (!this.tree.getVisibleRect().contains(point)) {
            cloneable = this.tree.getVisibleRect();
            Rectangle rectangle2 = new Rectangle(point.x - ((Rectangle)cloneable).width / 2, point.y - ((Rectangle)cloneable).height / 2, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
            this.tree.scrollRectToVisible(rectangle2);
        }
        cloneable = this.tree.getLocationOnScreen();
        ((Point)cloneable).translate(point.x, point.y);
        this.setLocationOnScreen((Point)cloneable);
        return true;
    }

    private TreeNode getNode(JTree jTree, String string) {
        if (string == null) {
            return null;
        }
        TreeModel treeModel = jTree.getModel();
        TreeNode treeNode = (TreeNode)treeModel.getRoot();
        if (this.checkNodesUserObject(treeNode, string)) {
            return treeNode;
        }
        List list = this.findNodeList(treeNode, new ArrayList());
        TreeNode treeNode2 = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            treeNode2 = (TreeNode)iterator.next();
            if (!this.checkNodesUserObject(treeNode2, string)) continue;
            return treeNode2;
        }
        return null;
    }

    private List findNodeList(TreeNode treeNode, List list) {
        int n = 0;
        while (n < treeNode.getChildCount()) {
            TreeNode treeNode2 = treeNode.getChildAt(n);
            list.add(treeNode2);
            this.findNodeList(treeNode2, list);
            ++n;
        }
        return list;
    }

    private boolean checkNodesUserObject(TreeNode treeNode, String string) {
        return treeNode != null && treeNode.toString().equals(string.toString());
    }

    private Object[] buildPath(TreeNode treeNode) {
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        if (treeNode != null) {
            arrayList.add(0, treeNode);
            TreeNode treeNode2 = treeNode.getParent();
            while (treeNode2 != null) {
                arrayList.add(0, treeNode2);
                treeNode2 = treeNode2.getParent();
            }
        }
        arrayList.trimToSize();
        return arrayList.toArray();
    }

    public boolean consume(AWTEvent aWTEvent) {
        if (super.consume(aWTEvent)) {
            return true;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        JTree jTree = (JTree)mouseEvent.getSource();
        this.setSource(jTree);
        this.setModifiers(mouseEvent.getModifiers());
        this.setNumberOfClicks(mouseEvent.getClickCount());
        this.setPopupTrigger(mouseEvent.isPopupTrigger());
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Point point2 = jTree.getLocationOnScreen();
        point2.translate(point.x, point.y);
        this.setLocationOnScreen(point2);
        int n = jTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
        TreePath treePath = jTree.getPathForRow(n);
        this.setTreePath(treePath);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean canConsume(AWTEvent aWTEvent) {
        if (!(aWTEvent.getSource() instanceof JTree && super.canConsume(aWTEvent) && this.sameSource(aWTEvent))) {
            return false;
        }
        if (this.isValid()) {
            int n = ((JTree)aWTEvent.getSource()).getRowForLocation(((MouseEvent)aWTEvent).getX(), ((MouseEvent)aWTEvent).getY());
            TreePath treePath = ((JTree)aWTEvent.getSource()).getPathForRow(n);
            if (!treePath.equals(this.getTreePath())) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(super.toString());
        stringBuffer.append(" nodeValue: " + this.getNodeValue());
        stringBuffer.append(" treePath: " + this.getTreePath());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JTreeMouseEventData)) {
            return false;
        }
        JTreeMouseEventData jTreeMouseEventData = (JTreeMouseEventData)object;
        if (!super.equals(object)) {
            return false;
        }
        TreePath treePath = this.getTreePath();
        TreePath treePath2 = jTreeMouseEventData.getTreePath();
        if (treePath != null && treePath2 != null && !jTreeMouseEventData.equals(this.treePath)) {
            return false;
        }
        return this.getNodeValue() == null || jTreeMouseEventData.getNodeValue() == null || this.getNodeValue().equals(jTreeMouseEventData.getNodeValue());
    }
}

