/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.text.JTextComponent;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;

public class JTextComponentMouseEventData
extends AbstractMouseEventData {
    private JTextComponent comp;
    private int offset = -1;

    public JTextComponentMouseEventData() {
        this.setValid(false);
    }

    public JTextComponentMouseEventData(JFCTestCase jFCTestCase, JTextComponent jTextComponent) {
        this(jFCTestCase, jTextComponent, 1);
    }

    public JTextComponentMouseEventData(JFCTestCase jFCTestCase, JTextComponent jTextComponent, int n) {
        this(jFCTestCase, jTextComponent, n, 16);
    }

    public JTextComponentMouseEventData(JFCTestCase jFCTestCase, JTextComponent jTextComponent, long l) {
        this(jFCTestCase, jTextComponent, 1, l);
    }

    public JTextComponentMouseEventData(JFCTestCase jFCTestCase, JTextComponent jTextComponent, int n, int n2) {
        this(jFCTestCase, jTextComponent, n, n2, false);
    }

    public JTextComponentMouseEventData(JFCTestCase jFCTestCase, JTextComponent jTextComponent, int n, boolean bl) {
        this(jFCTestCase, jTextComponent, n, AbstractMouseEventData.getDefaultModifiers(bl), bl);
    }

    public JTextComponentMouseEventData(JFCTestCase jFCTestCase, JTextComponent jTextComponent, int n, long l) {
        this(jFCTestCase, jTextComponent, n, 16, false, l);
    }

    public JTextComponentMouseEventData(JFCTestCase jFCTestCase, JTextComponent jTextComponent, int n, int n2, boolean bl) {
        this(jFCTestCase, jTextComponent, n, n2, bl, 300L);
    }

    public JTextComponentMouseEventData(JFCTestCase jFCTestCase, JTextComponent jTextComponent, int n, boolean bl, long l) {
        this(jFCTestCase, jTextComponent, n, AbstractMouseEventData.getDefaultModifiers(bl), bl, l);
    }

    public JTextComponentMouseEventData(JFCTestCase jFCTestCase, JTextComponent jTextComponent, int n, int n2, boolean bl, long l) {
        this(jFCTestCase, jTextComponent, n, n2, bl, l, 0, null, -1);
    }

    public JTextComponentMouseEventData(JFCTestCase jFCTestCase, JTextComponent jTextComponent, int n, int n2, boolean bl, long l, int n3) {
        this(jFCTestCase, jTextComponent, n, n2, bl, l, n3, null, -1);
    }

    public JTextComponentMouseEventData(JFCTestCase jFCTestCase, JTextComponent jTextComponent, int n, int n2, boolean bl, long l, int n3, int n4) {
        this(jFCTestCase, jTextComponent, n, n2, bl, l, 14, null, n4);
    }

    public JTextComponentMouseEventData(JFCTestCase jFCTestCase, JTextComponent jTextComponent, int n, int n2, boolean bl, long l, Point point) {
        this(jFCTestCase, jTextComponent, n, n2, bl, l, 12, point, -1);
    }

    public JTextComponentMouseEventData(JFCTestCase jFCTestCase, JTextComponent jTextComponent, int n, int n2, boolean bl, long l, int n3, Point point, int n4) {
        this.setTestCase(jFCTestCase);
        this.setSource(jTextComponent);
        this.setNumberOfClicks(n);
        this.setModifiers(n2);
        this.setPopupTrigger(bl);
        this.setSleepTime(l);
        this.setPosition(n3);
        this.setReferencePoint(point);
        this.setOffset(n4);
        this.setValid(true);
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setSource(JTextComponent jTextComponent) {
        this.comp = jTextComponent;
    }

    public JTextComponent getSource() {
        return this.comp;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public boolean prepareComponent() throws Exception {
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        this.requestFocus(this.comp);
        Point point = null;
        if (this.getPosition() == 14) {
            this.setPosition(3);
            point = this.calculatePoint(this.comp.modelToView(this.offset));
        } else {
            point = this.calculatePoint(this.comp.getBounds());
        }
        Point point2 = this.comp.getLocationOnScreen();
        point2.translate(point.x, point.y);
        this.setLocationOnScreen(point2);
        return true;
    }

    public boolean consume(AWTEvent aWTEvent) {
        if (super.consume(aWTEvent)) {
            return true;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
        this.setSource(jTextComponent);
        this.setModifiers(mouseEvent.getModifiers());
        this.setNumberOfClicks(mouseEvent.getClickCount());
        this.setPopupTrigger(mouseEvent.isPopupTrigger());
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Point point2 = jTextComponent.getLocationOnScreen();
        point2.translate(point.x, point.y);
        this.setLocationOnScreen(point2);
        int n = jTextComponent.viewToModel(point);
        this.setOffset(n);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean canConsume(AWTEvent aWTEvent) {
        return aWTEvent.getSource() instanceof JTextComponent && super.canConsume(aWTEvent) && this.sameSource(aWTEvent);
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(super.toString());
        stringBuffer.append(" offset: " + this.getOffset());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JTextComponentMouseEventData)) {
            return false;
        }
        JTextComponentMouseEventData jTextComponentMouseEventData = (JTextComponentMouseEventData)object;
        return super.equals(object) && jTextComponentMouseEventData.getOffset() == this.getOffset();
    }
}

