/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;

public class JTableMouseEventData
extends AbstractMouseEventData {
    private JTable table;
    private int rowIndex;
    private int columnIndex;

    public JTableMouseEventData() {
        this.setValid(false);
    }

    public JTableMouseEventData(JFCTestCase jFCTestCase, JTable jTable, int n, int n2, int n3) {
        this(jFCTestCase, jTable, n, n2, n3, 300L);
    }

    public JTableMouseEventData(JFCTestCase jFCTestCase, JTable jTable, int n, int n2, int n3, long l) {
        this(jFCTestCase, jTable, n, n2, n3, false, l);
    }

    public JTableMouseEventData(JFCTestCase jFCTestCase, JTable jTable, int n, int n2, int n3, boolean bl) {
        this(jFCTestCase, jTable, n, n2, n3, bl, 300L);
    }

    public JTableMouseEventData(JFCTestCase jFCTestCase, JTable jTable, int n, int n2, int n3, boolean bl, long l) {
        this(jFCTestCase, jTable, n, n2, n3, AbstractMouseEventData.getDefaultModifiers(bl), bl, l);
    }

    public JTableMouseEventData(JFCTestCase jFCTestCase, JTable jTable, int n, int n2, int n3, int n4, boolean bl, long l) {
        this(jFCTestCase, jTable, n, n2, n3, n4, bl, l, 0, null);
    }

    public JTableMouseEventData(JFCTestCase jFCTestCase, JTable jTable, int n, int n2, int n3, int n4, boolean bl, long l, int n5) {
        this(jFCTestCase, jTable, n, n2, n3, n4, bl, l, n5, null);
    }

    public JTableMouseEventData(JFCTestCase jFCTestCase, JTable jTable, int n, int n2, int n3, int n4, boolean bl, long l, Point point) {
        this(jFCTestCase, jTable, n, n2, n3, n4, bl, l, 12, point);
    }

    public JTableMouseEventData(JFCTestCase jFCTestCase, JTable jTable, int n, int n2, int n3, int n4, boolean bl, long l, int n5, Point point) {
        this.setTestCase(jFCTestCase);
        this.setSource(jTable);
        this.setNumberOfClicks(n3);
        this.setModifiers(n4);
        this.setPopupTrigger(bl);
        this.setRowIndex(n);
        this.setColumnIndex(n2);
        this.setSleepTime(l);
        this.setPosition(n5);
        this.setReferencePoint(point);
        this.setValid(true);
    }

    public void setSource(JTable jTable) {
        this.table = jTable;
    }

    public JTable getSource() {
        return this.table;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public void setRowIndex(int n) {
        this.rowIndex = n;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setColumnIndex(int n) {
        this.columnIndex = n;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public boolean prepareComponent() {
        Cloneable cloneable;
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        this.requestFocus(this.table);
        JFCTestCase jFCTestCase = this.getTestCase();
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        Rectangle rectangle = this.table.getCellRect(this.rowIndex, this.columnIndex, true);
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        Point point = this.calculatePoint(rectangle);
        if (!this.table.getVisibleRect().contains(point)) {
            cloneable = this.table.getVisibleRect();
            Rectangle rectangle2 = new Rectangle(point.x - ((Rectangle)cloneable).width / 2, point.y - ((Rectangle)cloneable).height / 2, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
            this.table.scrollRectToVisible(rectangle2);
        }
        cloneable = this.table.getLocationOnScreen();
        ((Point)cloneable).translate(point.x, point.y);
        this.setLocationOnScreen((Point)cloneable);
        return true;
    }

    public boolean consume(AWTEvent aWTEvent) {
        if (super.consume(aWTEvent)) {
            return true;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        JTable jTable = (JTable)mouseEvent.getSource();
        this.setSource(jTable);
        this.setModifiers(mouseEvent.getModifiers());
        this.setNumberOfClicks(mouseEvent.getClickCount());
        this.setPopupTrigger(mouseEvent.isPopupTrigger());
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Point point2 = jTable.getLocationOnScreen();
        point2.translate(point.x, point.y);
        this.setLocationOnScreen(point2);
        int n = jTable.rowAtPoint(point);
        int n2 = jTable.columnAtPoint(point);
        this.setRowIndex(n);
        this.setColumnIndex(n2);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean canConsume(AWTEvent aWTEvent) {
        return aWTEvent.getSource() instanceof JTable && super.canConsume(aWTEvent) && this.sameSource(aWTEvent);
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(super.toString());
        stringBuffer.append(" row: " + this.getRowIndex());
        stringBuffer.append(" column: " + this.getColumnIndex());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JTableMouseEventData)) {
            return false;
        }
        JTableMouseEventData jTableMouseEventData = (JTableMouseEventData)object;
        return super.equals(object) && jTableMouseEventData.getRowIndex() == this.getRowIndex() && jTableMouseEventData.getColumnIndex() == this.getColumnIndex();
    }
}

