/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;

public class JTableHeaderMouseEventData
extends AbstractMouseEventData {
    private JTableHeader header;
    private int columnIndex;

    public JTableHeaderMouseEventData() {
        this.setValid(false);
    }

    public JTableHeaderMouseEventData(JFCTestCase jFCTestCase, JTableHeader jTableHeader, int n, int n2) {
        this(jFCTestCase, jTableHeader, n, n2, 300L);
    }

    public JTableHeaderMouseEventData(JFCTestCase jFCTestCase, JTableHeader jTableHeader, int n, int n2, long l) {
        this(jFCTestCase, jTableHeader, n, n2, false, l);
    }

    public JTableHeaderMouseEventData(JFCTestCase jFCTestCase, JTableHeader jTableHeader, int n, int n2, boolean bl) {
        this(jFCTestCase, jTableHeader, n, n2, bl, 300L);
    }

    public JTableHeaderMouseEventData(JFCTestCase jFCTestCase, JTableHeader jTableHeader, int n, int n2, boolean bl, long l) {
        this(jFCTestCase, jTableHeader, n, n2, AbstractMouseEventData.getDefaultModifiers(bl), bl, l);
    }

    public JTableHeaderMouseEventData(JFCTestCase jFCTestCase, JTableHeader jTableHeader, int n, int n2, int n3, boolean bl, long l) {
        this(jFCTestCase, jTableHeader, n, n2, n3, bl, l, 0, null);
    }

    public JTableHeaderMouseEventData(JFCTestCase jFCTestCase, JTableHeader jTableHeader, int n, int n2, int n3, boolean bl, long l, int n4) {
        this(jFCTestCase, jTableHeader, n, n2, n3, bl, l, n4, null);
    }

    public JTableHeaderMouseEventData(JFCTestCase jFCTestCase, JTableHeader jTableHeader, int n, int n2, int n3, boolean bl, long l, Point point) {
        this(jFCTestCase, jTableHeader, n, n2, n3, bl, l, 12, point);
    }

    public JTableHeaderMouseEventData(JFCTestCase jFCTestCase, JTableHeader jTableHeader, int n, int n2, int n3, boolean bl, long l, int n4, Point point) {
        this.setTestCase(jFCTestCase);
        this.setSource(jTableHeader);
        this.setNumberOfClicks(n2);
        this.setModifiers(n3);
        this.setPopupTrigger(bl);
        this.setColumnIndex(n);
        this.setSleepTime(l);
        this.setPosition(n4);
        this.setReferencePoint(point);
        this.setValid(true);
    }

    public void setSource(JTableHeader jTableHeader) {
        this.header = jTableHeader;
    }

    public JTableHeader getSource() {
        return this.header;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public void setColumnIndex(int n) {
        this.columnIndex = n;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public boolean prepareComponent() {
        Cloneable cloneable;
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        this.requestFocus(this.header);
        JFCTestCase jFCTestCase = this.getTestCase();
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        Rectangle rectangle = this.header.getHeaderRect(this.columnIndex);
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        Point point = this.calculatePoint(rectangle);
        if (!this.header.getVisibleRect().contains(point)) {
            cloneable = this.header.getTable().getVisibleRect();
            Rectangle rectangle2 = new Rectangle(point.x - (int)(((Rectangle)cloneable).getWidth() / 2.0), (int)((Rectangle)cloneable).getY(), (int)((Rectangle)cloneable).getWidth(), (int)((Rectangle)cloneable).getHeight());
            this.header.getTable().scrollRectToVisible(rectangle2);
        }
        cloneable = this.header.getLocationOnScreen();
        ((Point)cloneable).translate(point.x, point.y);
        this.setLocationOnScreen((Point)cloneable);
        return true;
    }

    public boolean consume(AWTEvent aWTEvent) {
        if (super.consume(aWTEvent)) {
            return true;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        JTableHeader jTableHeader = (JTableHeader)mouseEvent.getSource();
        this.setSource(jTableHeader);
        this.setModifiers(mouseEvent.getModifiers());
        this.setNumberOfClicks(mouseEvent.getClickCount());
        this.setPopupTrigger(mouseEvent.isPopupTrigger());
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Point point2 = jTableHeader.getLocationOnScreen();
        point2.translate(point.x, point.y);
        this.setLocationOnScreen(point2);
        int n = jTableHeader.columnAtPoint(point);
        this.setColumnIndex(n);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean canConsume(AWTEvent aWTEvent) {
        return aWTEvent.getSource() instanceof JTableHeader && super.canConsume(aWTEvent) && this.sameSource(aWTEvent);
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(super.toString());
        stringBuffer.append(" column: " + this.getColumnIndex());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JTableHeaderMouseEventData)) {
            return false;
        }
        JTableHeaderMouseEventData jTableHeaderMouseEventData = (JTableHeaderMouseEventData)object;
        return super.equals(object) && jTableHeaderMouseEventData.getColumnIndex() == this.getColumnIndex();
    }
}

