/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JList;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;

public class JListMouseEventData
extends AbstractMouseEventData {
    private JList list;
    private int elementIndex;

    public JListMouseEventData() {
        this.setValid(false);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, Object object, int n) {
        this(jFCTestCase, jList, object, n, 300L);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, Object object, int n, long l) {
        this(jFCTestCase, jList, object, n, false, l);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, Object object, int n, boolean bl) {
        this(jFCTestCase, jList, object, n, AbstractMouseEventData.getDefaultModifiers(bl), bl, 300L);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, Object object, int n, boolean bl, long l) {
        this(jFCTestCase, jList, object, n, AbstractMouseEventData.getDefaultModifiers(bl), bl, l);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, Object object, int n, int n2, boolean bl, long l) {
        this(jFCTestCase, jList, object, n, n2, bl, l, 0, null);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, Object object, int n, int n2, boolean bl, long l, int n3) {
        this(jFCTestCase, jList, object, n, n2, bl, l, n3, null);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, Object object, int n, int n2, boolean bl, long l, Point point) {
        this(jFCTestCase, jList, object, n, n2, bl, l, 12, point);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, Object object, int n, int n2, boolean bl, long l, int n3, Point point) {
        this(jFCTestCase, jList, JListMouseEventData.getIndexOf(jList, object), n, n2, bl, l, n3, point);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, int n, int n2) {
        this(jFCTestCase, jList, n, n2, 300L);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, int n, int n2, long l) {
        this(jFCTestCase, jList, n, n2, false, l);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, int n, int n2, boolean bl) {
        this(jFCTestCase, jList, n, n2, AbstractMouseEventData.getDefaultModifiers(bl), bl, 300L);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, int n, int n2, boolean bl, long l) {
        this(jFCTestCase, jList, n, n2, AbstractMouseEventData.getDefaultModifiers(bl), bl, l);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, int n, int n2, int n3, boolean bl, long l) {
        this(jFCTestCase, jList, n, n2, n3, bl, l, 0, (Point)null);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, int n, int n2, int n3, boolean bl, long l, int n4) {
        this(jFCTestCase, jList, n, n2, n3, bl, l, n4, (Point)null);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, int n, int n2, int n3, boolean bl, long l, Point point) {
        this(jFCTestCase, jList, n, n2, n3, bl, l, 12, point);
    }

    public JListMouseEventData(JFCTestCase jFCTestCase, JList jList, int n, int n2, int n3, boolean bl, long l, int n4, Point point) {
        this.setTestCase(jFCTestCase);
        this.setSource(jList);
        this.setNumberOfClicks(n2);
        this.setModifiers(n3);
        this.setPopupTrigger(bl);
        this.setElementIndex(n);
        this.setSleepTime(l);
        this.setPosition(n4);
        this.setReferencePoint(point);
        this.setValid(true);
    }

    public void setSource(JList jList) {
        this.list = jList;
    }

    public JList getSource() {
        return this.list;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public void setElementIndex(int n) {
        this.elementIndex = n;
    }

    public int getElementIndex() {
        return this.elementIndex;
    }

    public boolean prepareComponent() {
        Cloneable cloneable;
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        this.requestFocus(this.list);
        this.list.ensureIndexIsVisible(this.elementIndex);
        JFCTestCase jFCTestCase = this.getTestCase();
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        Rectangle rectangle = this.list.getCellBounds(this.elementIndex, this.elementIndex);
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        Point point = this.calculatePoint(rectangle);
        if (!this.list.getVisibleRect().contains(point)) {
            cloneable = this.list.getVisibleRect();
            Rectangle rectangle2 = new Rectangle(point.x - ((Rectangle)cloneable).width / 2, point.y - ((Rectangle)cloneable).height / 2, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
            this.list.scrollRectToVisible(rectangle2);
        }
        cloneable = this.list.getLocationOnScreen();
        ((Point)cloneable).translate(point.x, point.y);
        this.setLocationOnScreen((Point)cloneable);
        return true;
    }

    public boolean consume(AWTEvent aWTEvent) {
        if (super.consume(aWTEvent)) {
            return true;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        JList jList = (JList)mouseEvent.getSource();
        this.setSource(jList);
        this.setModifiers(mouseEvent.getModifiers());
        this.setNumberOfClicks(mouseEvent.getClickCount());
        this.setPopupTrigger(mouseEvent.isPopupTrigger());
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Point point2 = jList.getLocationOnScreen();
        point2.translate(point.x, point.y);
        this.setLocationOnScreen(point2);
        int n = this.list.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY()));
        this.setElementIndex(n);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean canConsume(AWTEvent aWTEvent) {
        JList jList;
        int n;
        if (!(super.canConsume(aWTEvent) && aWTEvent.getSource() instanceof JList && this.sameSource(aWTEvent))) {
            return false;
        }
        return !this.isValid() || (n = (jList = (JList)aWTEvent.getSource()).locationToIndex(new Point(((MouseEvent)aWTEvent).getX(), ((MouseEvent)aWTEvent).getY()))) == this.getElementIndex();
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(super.toString());
        stringBuffer.append(" index: " + this.getElementIndex());
        return stringBuffer.toString();
    }

    private static final int getIndexOf(JList jList, Object object) {
        int n = -1;
        int n2 = 0;
        while (n2 < jList.getModel().getSize()) {
            if (jList.getModel().getElementAt(n2) != null && jList.getModel().getElementAt(n2).equals(object)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JListMouseEventData)) {
            return false;
        }
        JListMouseEventData jListMouseEventData = (JListMouseEventData)object;
        return super.equals(object) && jListMouseEventData.getElementIndex() == this.getElementIndex();
    }
}

