/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;

public class JComboBoxMouseEventData
extends AbstractMouseEventData {
    private JComboBox comboBox;
    private JList listView;
    private int elementIndex;

    public JComboBoxMouseEventData() {
        this.setValid(false);
    }

    public JComboBoxMouseEventData(JFCTestCase jFCTestCase, JComboBox jComboBox, Object object, int n) {
        this(jFCTestCase, jComboBox, object, n, 300L);
    }

    public JComboBoxMouseEventData(JFCTestCase jFCTestCase, JComboBox jComboBox, Object object, int n, long l) {
        this(jFCTestCase, jComboBox, object, n, 16, false, l);
    }

    public JComboBoxMouseEventData(JFCTestCase jFCTestCase, JComboBox jComboBox, Object object, int n, int n2, boolean bl, long l) {
        this(jFCTestCase, jComboBox, object, n, n2, bl, l, 0, null);
    }

    public JComboBoxMouseEventData(JFCTestCase jFCTestCase, JComboBox jComboBox, Object object, int n, int n2, boolean bl, long l, Point point) {
        this(jFCTestCase, jComboBox, object, n, n2, bl, l, 12, point);
    }

    public JComboBoxMouseEventData(JFCTestCase jFCTestCase, JComboBox jComboBox, Object object, int n, int n2, boolean bl, long l, int n3) {
        this(jFCTestCase, jComboBox, object, n, n2, bl, l, n3, null);
    }

    public JComboBoxMouseEventData(JFCTestCase jFCTestCase, JComboBox jComboBox, Object object, int n, int n2, boolean bl, long l, int n3, Point point) {
        this(jFCTestCase, jComboBox, JComboBoxMouseEventData.getIndexOf(jComboBox, object), n, n2, bl, l, n3, point);
    }

    public JComboBoxMouseEventData(JFCTestCase jFCTestCase, JComboBox jComboBox, int n, int n2) {
        this(jFCTestCase, jComboBox, n, n2, 300L);
    }

    public JComboBoxMouseEventData(JFCTestCase jFCTestCase, JComboBox jComboBox, int n, int n2, long l) {
        this(jFCTestCase, jComboBox, n, n2, 16, false, l);
    }

    public JComboBoxMouseEventData(JFCTestCase jFCTestCase, JComboBox jComboBox, int n, int n2, int n3, boolean bl, long l) {
        this(jFCTestCase, jComboBox, n, n2, n3, bl, l, 0, (Point)null);
    }

    public JComboBoxMouseEventData(JFCTestCase jFCTestCase, JComboBox jComboBox, int n, int n2, int n3, boolean bl, long l, Point point) {
        this(jFCTestCase, jComboBox, n, n2, n3, bl, l, 12, point);
    }

    public JComboBoxMouseEventData(JFCTestCase jFCTestCase, JComboBox jComboBox, int n, int n2, int n3, boolean bl, long l, int n4) {
        this(jFCTestCase, jComboBox, n, n2, n3, bl, l, n4, (Point)null);
    }

    public JComboBoxMouseEventData(JFCTestCase jFCTestCase, JComboBox jComboBox, int n, int n2, int n3, boolean bl, long l, int n4, Point point) {
        this.setTestCase(jFCTestCase);
        this.setSource(jComboBox);
        this.setNumberOfClicks(n2);
        this.setModifiers(n3);
        this.setPopupTrigger(bl);
        this.setElementIndex(n);
        this.setSleepTime(l);
        this.setPosition(n4);
        this.setReferencePoint(point);
        this.setValid(true);
    }

    public void setSource(JComboBox jComboBox) {
        this.comboBox = jComboBox;
    }

    public JComboBox getSource() {
        return this.comboBox;
    }

    public Component getComponent() {
        return this.listView;
    }

    public void setElementIndex(int n) {
        this.elementIndex = n;
    }

    public int getElementIndex() {
        return this.elementIndex;
    }

    public boolean prepareComponent() {
        Cloneable cloneable;
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        this.requestFocus(this.comboBox);
        JFCTestCase jFCTestCase = this.getTestCase();
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        this.comboBox.showPopup();
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        BasicComboPopup basicComboPopup = (BasicComboPopup)this.comboBox.getAccessibleContext().getAccessibleChild(0);
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        this.listView = basicComboPopup.getList();
        this.requestFocus(this.listView);
        this.listView.ensureIndexIsVisible(this.elementIndex);
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        Rectangle rectangle = this.listView.getCellBounds(this.elementIndex, this.elementIndex);
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        Point point = this.calculatePoint(rectangle);
        if (!this.listView.getVisibleRect().contains(point)) {
            cloneable = this.listView.getVisibleRect();
            Rectangle rectangle2 = new Rectangle(point.x - ((Rectangle)cloneable).width / 2, point.y - ((Rectangle)cloneable).height / 2, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
            this.listView.scrollRectToVisible(rectangle2);
        }
        cloneable = this.listView.getLocationOnScreen();
        ((Point)cloneable).translate(point.x, point.y);
        this.setLocationOnScreen((Point)cloneable);
        return true;
    }

    private JComboBox getParentComboBox(JList jList) {
        Accessible accessible = jList.getAccessibleContext().getAccessibleParent();
        while (accessible != null) {
            if (accessible instanceof JComboBox) {
                return (JComboBox)accessible;
            }
            accessible = accessible.getAccessibleContext().getAccessibleParent();
        }
        return null;
    }

    private boolean isComboBox(JList jList) {
        Accessible accessible = jList.getAccessibleContext().getAccessibleParent();
        while (accessible != null) {
            if (accessible instanceof ComboBoxUI || accessible.getClass().getName().indexOf("ComboBoxUI") != -1) {
                return true;
            }
            accessible = accessible.getAccessibleContext().getAccessibleParent();
        }
        return false;
    }

    public boolean consume(AWTEvent aWTEvent) {
        if (super.consume(aWTEvent)) {
            return true;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        JList jList = (JList)mouseEvent.getSource();
        this.setSource(this.getParentComboBox(jList));
        this.setModifiers(mouseEvent.getModifiers());
        this.setNumberOfClicks(mouseEvent.getClickCount());
        this.setPopupTrigger(mouseEvent.isPopupTrigger());
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Point point2 = jList.getLocationOnScreen();
        point2.translate(point.x, point.y);
        this.setLocationOnScreen(point2);
        int n = jList.locationToIndex(new Point(mouseEvent.getX(), mouseEvent.getY()));
        this.setElementIndex(n);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean canConsume(AWTEvent aWTEvent) {
        JList jList;
        int n;
        if (!super.canConsume(aWTEvent) || !(aWTEvent.getSource() instanceof JList)) {
            return false;
        }
        if (this.isValid() && (n = (jList = (JList)aWTEvent.getSource()).locationToIndex(new Point(((MouseEvent)aWTEvent).getX(), ((MouseEvent)aWTEvent).getY()))) != this.getElementIndex()) {
            return false;
        }
        return this.isComboBox((JList)aWTEvent.getSource());
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(super.toString());
        stringBuffer.append(" index: " + this.getElementIndex());
        return stringBuffer.toString();
    }

    private static final int getIndexOf(JComboBox jComboBox, Object object) {
        int n = 0;
        while (n < jComboBox.getItemCount()) {
            if (jComboBox.getItemAt(n) != null && jComboBox.getItemAt(n).equals(object)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (!(object instanceof JComboBoxMouseEventData)) {
            return false;
        }
        JComboBoxMouseEventData jComboBoxMouseEventData = (JComboBoxMouseEventData)object;
        return super.equals(object) && jComboBoxMouseEventData.getSource() == this.getSource() && jComboBoxMouseEventData.getElementIndex() == this.getElementIndex();
    }
}

