/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.Component;
import java.awt.Point;
import java.text.ParseException;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import junit.extensions.jfcunit.eventdata.EventDataConstants;
import junit.extensions.jfcunit.xml.JFCXMLConstants;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.elements.AbstractTagHandler;
import junit.framework.Assert;
import org.w3c.dom.Element;

public abstract class BaseEventDataTagHandler
extends AbstractTagHandler
implements EventDataConstants,
JFCXMLConstants {
    private AbstractMouseEventData eventData = null;

    public BaseEventDataTagHandler(Element element, IXMLTestCase iXMLTestCase) {
        super(element, iXMLTestCase);
    }

    public void validateElement() throws XMLException {
        super.validateElement();
        this.checkRequiredAttribute("refid");
    }

    protected Component getComponent() {
        Component component = (Component)this.getTestCase().getFoundObject(this.getString("refid"));
        Assert.assertNotNull((String)("Component for " + this.getString("refid") + " is null"), (Object)component);
        return component;
    }

    protected int getClicks() {
        return this.getInt("clicks", 1);
    }

    protected int getModifiers() {
        return this.getModifiers(16);
    }

    protected int getModifiers(int n) {
        int n2 = 0;
        String string = this.getString("modifiers");
        if (string == null) {
            return n;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string.indexOf("shift") != -1) {
                ++n2;
            }
            if (string.indexOf("control") != -1) {
                n2 += 2;
            }
            if (string.indexOf("alt") != -1) {
                n2 += 8;
            }
            if (string.indexOf("altgraph") != -1) {
                n2 += 32;
            }
            if (string.indexOf("meta") != -1) {
                n2 += 4;
            }
            boolean bl = false;
            if (string.indexOf("button1") != -1) {
                bl = true;
                n2 += 16;
            }
            if (string.indexOf("button2") != -1) {
                bl = true;
                n2 += 8;
            }
            if (string.indexOf("button3") != -1) {
                bl = true;
                n2 += 4;
            }
            if (!bl) {
                int n3 = AbstractMouseEventData.getDefaultModifiers(this.getPopupTrigger());
                n2 |= n3;
            }
            return n2;
        }
    }

    protected int getPosition() {
        String string = this.getString("position");
        if ("CENTER".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("NORTH".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("NORTH_EAST".equalsIgnoreCase(string) || "NORTHEAST".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("EAST".equalsIgnoreCase(string)) {
            return 3;
        }
        if ("SOUTH_EAST".equalsIgnoreCase(string) || "SOUTHEAST".equalsIgnoreCase(string)) {
            return 4;
        }
        if ("SOUTH".equalsIgnoreCase(string)) {
            return 5;
        }
        if ("SOUTH_WEST".equalsIgnoreCase(string) || "SOUTHWEST".equalsIgnoreCase(string)) {
            return 6;
        }
        if ("WEST".equalsIgnoreCase(string)) {
            return 7;
        }
        if ("NORTH_WEST".equalsIgnoreCase(string) || "NORTHWEST".equalsIgnoreCase(string)) {
            return 8;
        }
        if ("CUSTOM".equalsIgnoreCase(string)) {
            return 12;
        }
        if ("PERCENT".equalsIgnoreCase(string)) {
            return 13;
        }
        return this.getInt("position", 0);
    }

    protected boolean getPopupTrigger() {
        return this.getBoolean("popup");
    }

    protected long getSleepTime() {
        return this.getLong("sleeptime", 300L);
    }

    protected Point getReference() throws ParseException {
        return this.getPoint("reference", null);
    }

    public JFCTestCase getJFCTestCase() {
        IXMLTestCase iXMLTestCase = super.getTestCase();
        if (iXMLTestCase instanceof JFCTestCase) {
            return (JFCTestCase)((Object)iXMLTestCase);
        }
        return null;
    }

    protected int getOffset() {
        try {
            return this.getInt("index", -1);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Invalid offset specification");
        }
    }

    AbstractMouseEventData getEventData() throws Exception {
        this.processElement();
        return this.eventData;
    }

    void setEventData(AbstractMouseEventData abstractMouseEventData) {
        this.eventData = abstractMouseEventData;
    }
}

