/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import junit.extensions.jfcunit.ExitException;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.JFCTestException;
import junit.extensions.jfcunit.WindowMonitor;
import junit.extensions.jfcunit.eventdata.AbstractKeyEventData;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import junit.extensions.jfcunit.eventdata.DragEventData;
import junit.extensions.jfcunit.eventdata.JComboBoxMouseEventData;
import junit.extensions.jfcunit.eventdata.JListMouseEventData;
import junit.extensions.jfcunit.eventdata.KeyEventData;
import junit.extensions.jfcunit.eventdata.MouseWheelEventData;
import junit.extensions.jfcunit.eventdata.StringEventData;
import junit.extensions.jfcunit.finder.AbstractWindowFinder;
import junit.extensions.jfcunit.finder.ComponentFinder;
import junit.extensions.jfcunit.finder.DialogFinder;
import junit.extensions.jfcunit.finder.Finder;
import junit.extensions.jfcunit.finder.FrameFinder;
import junit.extensions.jfcunit.finder.NamedComponentFinder;
import junit.extensions.jfcunit.keyboard.DefaultKeyMapping;
import junit.extensions.jfcunit.keyboard.JFCKeyStroke;
import junit.extensions.jfcunit.keyboard.KeyMapping;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public abstract class TestHelper {
    public static final long DEFAULTSLEEP = 300L;
    private static KeyMapping keyMapping = null;
    private static HashMap systemWindows = new HashMap();
    private static final Object LOCK = new Object();
    static /* synthetic */ Class class$javax$swing$JLabel;
    static /* synthetic */ Class class$javax$swing$JFileChooser;

    protected TestHelper() {
    }

    public static void cleanUp(JFCTestCase jFCTestCase) {
        TestHelper.cleanUp(jFCTestCase, 300L);
    }

    public static void cleanUp(JFCTestCase jFCTestCase, long l) {
        Iterator iterator = TestHelper.getWindows().iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            Window window = (Window)iterator.next();
            String string = null;
            if (window instanceof Dialog) {
                string = ((Dialog)window).getTitle();
            } else if (window instanceof Frame) {
                string = ((Frame)window).getTitle();
            }
            if (string != null) {
                Iterator iterator2 = systemWindows.values().iterator();
                while (iterator2.hasNext() && !bl) {
                    RE rE = (RE)iterator2.next();
                    if (!rE.match(string)) continue;
                    bl = true;
                }
            }
            if (bl) continue;
            TestHelper.disposeWindow(window, jFCTestCase, l);
        }
    }

    public static void disposeWindow(Window window, JFCTestCase jFCTestCase) {
        TestHelper.disposeWindow(window, jFCTestCase, 300L);
    }

    public static void disposeWindow(Window window, JFCTestCase jFCTestCase, long l) {
        if (window != null) {
            boolean bl = jFCTestCase.isAWTRunning();
            if (bl) {
                jFCTestCase.pauseAWT();
            }
            try {
                if (!(window instanceof JDialog)) {
                    List list = TestHelper.getShowingDialogs(window);
                    int n = 0;
                    while (n < list.size()) {
                        TestHelper.disposeWindow((JDialog)list.get(n), jFCTestCase, l);
                        ++n;
                    }
                }
                ((Component)window).setVisible(false);
                jFCTestCase.flushAWT();
                if (!bl) {
                    jFCTestCase.pauseAWT();
                }
                try {
                    window.getToolkit().getSystemEventQueue().postEvent(new WindowEvent(window, 201));
                }
                catch (ExitException exitException) {
                }
                Object var8_7 = null;
                jFCTestCase.setSleepTime(l);
                jFCTestCase.flushAWT();
                if (!bl) {
                    jFCTestCase.pauseAWT();
                }
                jFCTestCase.awtSleep();
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                jFCTestCase.setSleepTime(l);
                jFCTestCase.flushAWT();
                if (!bl) {
                    jFCTestCase.pauseAWT();
                }
                jFCTestCase.awtSleep();
                throw throwable;
            }
        }
    }

    public static final void addSystemWindow(String string) throws RESyntaxException {
        if (string == null) {
            return;
        }
        RE rE = new RE(string);
        systemWindows.put(string, rE);
    }

    public static final void removeSystemWindow(String string) {
        systemWindows.remove(string);
    }

    public static final void removeAllSystemWindows() {
        systemWindows.clear();
    }

    public static final Set getSystemWindows() {
        return Collections.unmodifiableSet(systemWindows.keySet());
    }

    public String getMessageFromJDialog(JDialog jDialog) {
        if (jDialog == null || !jDialog.isShowing()) {
            return null;
        }
        List list = TestHelper.findComponentList(new ComponentFinder(class$javax$swing$JLabel == null ? (class$javax$swing$JLabel = TestHelper.class$("javax.swing.JLabel")) : class$javax$swing$JLabel), jDialog, new ArrayList(), 10);
        int n = 0;
        while (n < list.size()) {
            JLabel jLabel = (JLabel)list.get(n);
            if (jLabel != null && jLabel.getText() != null) {
                return jLabel.getText();
            }
            ++n;
        }
        return null;
    }

    public static Window getWindow(String string) throws JFCTestException {
        return TestHelper.getWindow(new FrameFinder(string));
    }

    public static Window getWindow(AbstractWindowFinder abstractWindowFinder) throws JFCTestException {
        Iterator iterator = TestHelper.getWindows(abstractWindowFinder).iterator();
        if (!iterator.hasNext()) {
            throw new JFCTestException("Window with title '" + abstractWindowFinder.getTitle() + "' not found");
        }
        return (Window)iterator.next();
    }

    public static Set getWindows() {
        return TestHelper.getWindows((String)null);
    }

    public static Set getWindows(String string) {
        return TestHelper.getWindows(new FrameFinder(string));
    }

    public static Set getWindows(AbstractWindowFinder abstractWindowFinder) {
        return TestHelper.getWindows(new HashSet(), TestHelper.getAllWindows(), abstractWindowFinder);
    }

    public static Set getWindows(Set set, Window[] windowArray, String string) {
        return TestHelper.getWindows(set, windowArray, new FrameFinder(string));
    }

    public static Set getWindows(Set hashSet, Window[] windowArray, Finder finder) {
        if (hashSet == null) {
            hashSet = new HashSet<Frame>();
        }
        if (windowArray == null || finder == null) {
            return hashSet;
        }
        int n = 0;
        while (n < windowArray.length) {
            Frame frame;
            if (finder.testComponent(windowArray[n]) && !"JUnit".equalsIgnoreCase((frame = (Frame)windowArray[n]).getTitle())) {
                if (!hashSet.contains(frame)) {
                    hashSet.add(frame);
                }
                TestHelper.getWindows(hashSet, frame.getOwnedWindows(), finder);
            }
            ++n;
        }
        return hashSet;
    }

    public static List getShowingDialogs() {
        return TestHelper.getShowingDialogs((String)null);
    }

    public static List getShowingDialogs(Window window) {
        return TestHelper.getShowingDialogs(window, null);
    }

    public static List getShowingDialogs(String string) {
        Set set = TestHelper.getWindows();
        set.add(new JDialog().getOwner());
        Window[] windowArray = new Window[set.size() + 1];
        windowArray = set.toArray(windowArray);
        return TestHelper.getShowingDialogs(windowArray, string);
    }

    public static List getShowingDialogs(Window window, String string) {
        return TestHelper.getShowingDialogs(new Window[]{window}, string);
    }

    public static List getShowingDialogs(Window[] windowArray, String string) {
        return TestHelper.getShowingDialogs(new ArrayList(), windowArray, string);
    }

    public static List getShowingDialogs(List list, Window[] windowArray, String string) {
        return TestHelper.getShowingDialogs(list, windowArray, new DialogFinder(string));
    }

    public static List getShowingDialogs(List arrayList, Window[] windowArray, Finder finder) {
        if (arrayList == null) {
            arrayList = new ArrayList<Window>();
        }
        if (windowArray == null || finder == null) {
            return arrayList;
        }
        Object var3_3 = null;
        int n = 0;
        while (n < windowArray.length) {
            if (windowArray[n] != null) {
                if (finder.testComponent(windowArray[n]) && !arrayList.contains(windowArray[n])) {
                    arrayList.add(windowArray[n]);
                }
                TestHelper.getShowingDialogs(arrayList, windowArray[n].getOwnedWindows(), finder);
            }
            ++n;
        }
        return arrayList;
    }

    public JFileChooser getShowingJFileChooser(Window window) {
        List list = this.getShowingJFileChoosers(window);
        return list.isEmpty() ? null : (JFileChooser)list.get(0);
    }

    public List getShowingJFileChoosers(Window window) {
        ArrayList<JFileChooser> arrayList = new ArrayList<JFileChooser>();
        Window[] windowArray = window.getOwnedWindows();
        ComponentFinder componentFinder = new ComponentFinder(class$javax$swing$JFileChooser == null ? (class$javax$swing$JFileChooser = TestHelper.class$("javax.swing.JFileChooser")) : class$javax$swing$JFileChooser);
        int n = 0;
        while (n < windowArray.length) {
            if (windowArray[n] instanceof JDialog) {
                List list = TestHelper.findComponentList(componentFinder, windowArray[n], new ArrayList(), 0);
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    JFileChooser jFileChooser = (JFileChooser)iterator.next();
                    if (!((Finder)componentFinder).testComponent(jFileChooser)) continue;
                    arrayList.add(jFileChooser);
                }
            }
            ++n;
        }
        return arrayList;
    }

    public static Component findComponent(Class clazz, int n) {
        return TestHelper.findComponent(clazz, null, n);
    }

    public static Component findComponent(Class clazz, Container container, int n) {
        return TestHelper.findComponent(new ComponentFinder(clazz), container, n);
    }

    public static Component findNamedComponent(Class clazz, int n) {
        return TestHelper.findComponent(new NamedComponentFinder(clazz, null), n);
    }

    public static Component findNamedComponent(String string, int n) {
        return TestHelper.findComponent(new NamedComponentFinder(null, string), n);
    }

    public static Component findNamedComponent(Class clazz, String string, int n) {
        return TestHelper.findComponent(new NamedComponentFinder(clazz, string), n);
    }

    public static Component findComponent(Finder finder, int n) {
        Window[] windowArray = TestHelper.getAllWindows();
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        while (n3 < windowArray.length) {
            List list = TestHelper.findComponentList(finder, windowArray[n3], new ArrayList(), n - n2);
            if (list.size() > n - n2) {
                return (Component)list.get(n - n2);
            }
            n2 += list.size();
            ++n3;
        }
        return null;
    }

    public static Component findNamedComponent(String string, Container container, int n) {
        return TestHelper.findNamedComponent(null, string, container, n);
    }

    public static Component findNamedComponent(Class clazz, Container container, int n) {
        return TestHelper.findNamedComponent(clazz, null, container, n);
    }

    public static Component findNamedComponent(Class clazz, String string, Container container, int n) {
        return TestHelper.findComponent(new NamedComponentFinder(clazz, string), container, n);
    }

    public static Component findComponent(Finder finder, Container container, int n) {
        List list = TestHelper.findComponentList(finder, container, new ArrayList(), n);
        return list.size() > n ? (Component)list.get(n) : null;
    }

    private static List findComponentList(Finder finder, Container container, List arrayList, int n) {
        if (arrayList == null) {
            arrayList = new ArrayList<Component>();
        }
        if (container == null || finder == null) {
            return arrayList;
        }
        Component[] componentArray = container.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            if (finder.testComponent(componentArray[n2])) {
                if (!arrayList.contains(componentArray[n2])) {
                    arrayList.add(componentArray[n2]);
                }
                if (arrayList.size() > n) {
                    return arrayList;
                }
            } else if (componentArray[n2] instanceof Container) {
                TestHelper.findComponentList(finder, (Container)componentArray[n2], arrayList, n);
                if (arrayList.size() > n) {
                    return arrayList;
                }
            }
            ++n2;
        }
        return arrayList;
    }

    protected static int mouseToKeyModifiers(int n) {
        int n2 = n;
        int n3 = 28;
        return n2 &= -1 + n3;
    }

    public void enterDropDownClickAndLeave(JFCTestCase jFCTestCase, JComboBox jComboBox, Object object, int n) throws Exception {
        this.enterDropDownClickAndLeave(jFCTestCase, jComboBox, object, n, 300L);
    }

    public void enterDropDownClickAndLeave(JFCTestCase jFCTestCase, JComboBox jComboBox, Object object, int n, long l) throws Exception {
        int n2 = -1;
        int n3 = 0;
        while (n3 < jComboBox.getItemCount()) {
            if (jComboBox.getItemAt(n3) != null && jComboBox.getItemAt(n3).equals(object)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        this.enterClickAndLeave(new JComboBoxMouseEventData(jFCTestCase, jComboBox, n2, n, l));
    }

    public void enterJListClickAndLeave(JFCTestCase jFCTestCase, JList jList, Object object, int n) throws Exception {
        this.enterJListClickAndLeave(jFCTestCase, jList, object, n, 300L);
    }

    public void enterJListClickAndLeave(JFCTestCase jFCTestCase, JList jList, Object object, int n, long l) throws Exception {
        int n2 = -1;
        int n3 = 0;
        while (n3 < jList.getModel().getSize()) {
            if (jList.getModel().getElementAt(n3) != null && jList.getModel().getElementAt(n3).equals(object)) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        this.enterJListClickAndLeave(jFCTestCase, jList, n2, n, l);
    }

    public void enterJListClickAndLeave(JFCTestCase jFCTestCase, JList jList, int n, int n2) throws Exception {
        this.enterJListClickAndLeave(jFCTestCase, jList, n, n2, 300L);
    }

    public void enterJListClickAndLeave(JFCTestCase jFCTestCase, JList jList, int n, int n2, long l) throws Exception {
        this.enterClickAndLeave(new JListMouseEventData(jFCTestCase, jList, n, n2, l));
    }

    public void sendString(JFCTestCase jFCTestCase, Component component, String string) throws Exception {
        this.sendString(jFCTestCase, component, string, 0);
    }

    public void sendString(JFCTestCase jFCTestCase, Component component, String string, int n) throws Exception {
        this.sendString(jFCTestCase, component, string, n, 300L);
    }

    public void sendString(JFCTestCase jFCTestCase, Component component, String string, int n, long l) throws Exception {
        this.sendString(new StringEventData(jFCTestCase, component, string, n, l));
    }

    public void sendKeyAction(JFCTestCase jFCTestCase, Component component, int n) throws Exception {
        this.sendKeyAction(jFCTestCase, component, n, 0);
    }

    public void sendKeyAction(JFCTestCase jFCTestCase, Component component, int n, int n2) throws Exception {
        this.sendKeyAction(jFCTestCase, component, n, n2, 300L);
    }

    public void sendKeyAction(JFCTestCase jFCTestCase, Component component, int n, int n2, long l) throws Exception {
        this.sendKeyAction(new KeyEventData(jFCTestCase, component, n, n2, l));
    }

    public void sendKeyAction(KeyEventData keyEventData) throws Exception {
        this.sendString(keyEventData);
    }

    public static Window[] getAllWindows() {
        return WindowMonitor.getWindows();
    }

    public static KeyMapping getKeyMapping() {
        Object object = LOCK;
        synchronized (object) {
            if (keyMapping == null) {
                TestHelper.setKeyMapping(new DefaultKeyMapping());
            }
            LOCK.notifyAll();
        }
        return keyMapping;
    }

    public static void setKeyMapping(KeyMapping keyMapping) {
        Object object = LOCK;
        synchronized (object) {
            TestHelper.keyMapping = keyMapping;
            LOCK.notifyAll();
        }
    }

    protected final void pressModifiers(Component component, int n) throws Exception {
        this.adjustModifiers(component, 0, n);
    }

    protected final void releaseModifiers(Component component, int n) throws Exception {
        this.adjustModifiers(component, n, 0);
    }

    protected final void adjustModifiers(Component component, int n, int n2) throws Exception {
        JFCKeyStroke[] jFCKeyStrokeArray;
        if (n == n2) {
            return;
        }
        boolean bl = (n & 1) > 0;
        boolean bl2 = (n2 & 1) > 0;
        boolean bl3 = (n & 2) > 0;
        boolean bl4 = (n2 & 2) > 0;
        boolean bl5 = (n & 4) > 0;
        boolean bl6 = (n2 & 4) > 0;
        boolean bl7 = (n & 8) > 0;
        boolean bl8 = (n2 & 8) > 0;
        boolean bl9 = (n & 0x20) > 0;
        boolean bl10 = (n2 & 0x20) > 0;
        int n3 = n;
        if (bl && !bl2) {
            jFCKeyStrokeArray = TestHelper.getKeyMapping().getKeyStrokes(16);
            jFCKeyStrokeArray[0].setModifiers(n3 &= 0xFFFFFFFE);
            this.keyReleased(component, jFCKeyStrokeArray[0]);
        } else if (!bl && bl2) {
            jFCKeyStrokeArray = TestHelper.getKeyMapping().getKeyStrokes(16);
            jFCKeyStrokeArray[0].setModifiers(n3 |= 1);
            this.keyPressed(component, jFCKeyStrokeArray[0]);
        }
        if (bl3 && !bl4) {
            jFCKeyStrokeArray = TestHelper.getKeyMapping().getKeyStrokes(17);
            jFCKeyStrokeArray[0].setModifiers(n3 &= 0xFFFFFFFD);
            this.keyReleased(component, jFCKeyStrokeArray[0]);
        } else if (!bl3 && bl4) {
            jFCKeyStrokeArray = TestHelper.getKeyMapping().getKeyStrokes(17);
            jFCKeyStrokeArray[0].setModifiers(n3 |= 2);
            this.keyPressed(component, jFCKeyStrokeArray[0]);
        }
        if (bl7 && !bl8) {
            jFCKeyStrokeArray = TestHelper.getKeyMapping().getKeyStrokes(18);
            jFCKeyStrokeArray[0].setModifiers(n3 &= 0xFFFFFFF7);
            this.keyReleased(component, jFCKeyStrokeArray[0]);
        } else if (!bl7 && bl8) {
            jFCKeyStrokeArray = TestHelper.getKeyMapping().getKeyStrokes(18);
            jFCKeyStrokeArray[0].setModifiers(n3 |= 8);
            this.keyPressed(component, jFCKeyStrokeArray[0]);
        }
        if (bl9 && !bl10) {
            jFCKeyStrokeArray = TestHelper.getKeyMapping().getKeyStrokes(65406);
            jFCKeyStrokeArray[0].setModifiers(n3 &= 0xFFFFFFDF);
            this.keyReleased(component, jFCKeyStrokeArray[0]);
        } else if (!bl9 && bl10) {
            jFCKeyStrokeArray = TestHelper.getKeyMapping().getKeyStrokes(65406);
            jFCKeyStrokeArray[0].setModifiers(n3 |= 0x20);
            this.keyPressed(component, jFCKeyStrokeArray[0]);
        }
        if (bl5 && !bl6) {
            jFCKeyStrokeArray = TestHelper.getKeyMapping().getKeyStrokes(157);
            jFCKeyStrokeArray[0].setModifiers(n3 &= 0xFFFFFFFB);
            this.keyReleased(component, jFCKeyStrokeArray[0]);
        } else if (!bl5 && bl6) {
            jFCKeyStrokeArray = TestHelper.getKeyMapping().getKeyStrokes(157);
            jFCKeyStrokeArray[0].setModifiers(n3 |= 4);
            this.keyPressed(component, jFCKeyStrokeArray[0]);
        }
    }

    public void sendString(AbstractKeyEventData abstractKeyEventData) throws Exception {
        if (abstractKeyEventData == null) {
            return;
        }
        abstractKeyEventData.getTestCase().pauseAWT();
        if (!abstractKeyEventData.prepareComponent()) {
            abstractKeyEventData.getTestCase().resumeAWT();
            return;
        }
        abstractKeyEventData.getTestCase().resumeAWT();
        Component component = abstractKeyEventData.getRoot();
        int n = abstractKeyEventData.getModifiers();
        abstractKeyEventData.getTestCase().flushAWT();
        this.pressModifiers(component, n);
        JFCKeyStroke[] jFCKeyStrokeArray = abstractKeyEventData.getKeyStrokes();
        int n2 = 0;
        while (n2 < jFCKeyStrokeArray.length) {
            this.adjustModifiers(component, n, jFCKeyStrokeArray[n2].getModifiers());
            n = jFCKeyStrokeArray[n2].getModifiers();
            long l = System.currentTimeMillis();
            this.keyPressed(component, jFCKeyStrokeArray[n2]);
            this.keyReleased(component, jFCKeyStrokeArray[n2]);
            ++n2;
        }
        this.releaseModifiers(component, n);
        abstractKeyEventData.getTestCase().flushAWT();
    }

    public void enterClickAndLeave(AbstractMouseEventData abstractMouseEventData) throws Exception {
        if (abstractMouseEventData == null) {
            return;
        }
        abstractMouseEventData.getTestCase().pauseAWT();
        if (!abstractMouseEventData.prepareComponent()) {
            abstractMouseEventData.getTestCase().resumeAWT();
            return;
        }
        abstractMouseEventData.getTestCase().resumeAWT();
        int n = abstractMouseEventData.getNumberOfClicks();
        int n2 = abstractMouseEventData.getModifiers();
        boolean bl = abstractMouseEventData.getPopupTrigger();
        Component component = abstractMouseEventData.getRoot();
        abstractMouseEventData.getTestCase().flushAWT();
        Point point = abstractMouseEventData.getLocationOnScreen();
        this.pressModifiers(component, TestHelper.mouseToKeyModifiers(n2));
        this.mouseMoved(component, point.x - 5, point.y - 5);
        this.mouseMoved(component, point.x, point.y);
        int n3 = 1;
        while (n3 <= n) {
            this.mousePressed(component, n2, n3, bl);
            this.mouseReleased(component, n2, n3, bl);
            ++n3;
        }
        this.releaseModifiers(component, TestHelper.mouseToKeyModifiers(n2));
        abstractMouseEventData.getTestCase().flushAWT();
    }

    public void enterDragAndLeave(AbstractMouseEventData abstractMouseEventData, AbstractMouseEventData abstractMouseEventData2, int n) throws Exception {
        this.enterDragAndLeave(new DragEventData(abstractMouseEventData.getTestCase(), abstractMouseEventData, abstractMouseEventData2));
    }

    public void enterDragAndLeave(DragEventData dragEventData) throws Exception {
        dragEventData.getTestCase().pauseAWT();
        if (!dragEventData.prepareComponent()) {
            dragEventData.getTestCase().resumeAWT();
            return;
        }
        dragEventData.getTestCase().resumeAWT();
        int n = dragEventData.getSource().getNumberOfClicks();
        int n2 = dragEventData.getSource().getModifiers();
        int n3 = TestHelper.mouseToKeyModifiers(n2);
        int n4 = n2 & 0x1C;
        boolean bl = dragEventData.getSource().getPopupTrigger();
        Component component = dragEventData.getSource().getComponent();
        Point point = dragEventData.getSource().getLocationOnScreen();
        dragEventData.getTestCase().flushAWT();
        this.mouseMoved(component, point.x - 5, point.y - 5);
        this.mouseMoved(component, point.x, point.y);
        this.pressModifiers(component, n3);
        this.mousePressed(component, n4, 0, bl);
        Point[] pointArray = dragEventData.getPoints();
        int n5 = 0;
        while (n5 < pointArray.length) {
            this.mouseMoved(component, pointArray[n5].x, pointArray[n5].y);
            ++n5;
        }
        this.mouseReleased(component, n4, n, bl);
        this.releaseModifiers(component, n3);
        dragEventData.getTestCase().flushAWT();
    }

    public void enterMouseWheel(MouseWheelEventData mouseWheelEventData) throws Exception {
        if (mouseWheelEventData == null) {
            return;
        }
        mouseWheelEventData.getTestCase().pauseAWT();
        if (!mouseWheelEventData.prepareComponent()) {
            mouseWheelEventData.getTestCase().resumeAWT();
            return;
        }
        mouseWheelEventData.getTestCase().resumeAWT();
        int n = mouseWheelEventData.getWheelRotation();
        int n2 = mouseWheelEventData.getModifiers();
        boolean bl = mouseWheelEventData.getPopupTrigger();
        Component component = mouseWheelEventData.getSource();
        Point point = mouseWheelEventData.getLocationOnScreen();
        this.pressModifiers(component, TestHelper.mouseToKeyModifiers(n2));
        mouseWheelEventData.getTestCase().flushAWT();
        this.mouseMoved(component, point.x - 5, point.y - 5);
        this.mouseMoved(component, point.x, point.y);
        int n3 = n > 0 ? 1 : -1;
        int n4 = n > 0 ? n : -1 * n;
        int n5 = 0;
        while (n5 < n4) {
            this.mouseWheel(component, mouseWheelEventData.getScrollAmount(), n3);
            ++n5;
        }
        mouseWheelEventData.getTestCase().flushAWT();
        this.releaseModifiers(component, TestHelper.mouseToKeyModifiers(n2));
        mouseWheelEventData.getTestCase().flushAWT();
    }

    protected abstract void mouseMoved(Component var1, int var2, int var3) throws Exception;

    protected abstract void mousePressed(Component var1, int var2, int var3, boolean var4) throws Exception;

    protected abstract void mouseReleased(Component var1, int var2, int var3, boolean var4) throws Exception;

    protected abstract void mouseWheel(Component var1, int var2, int var3) throws Exception;

    protected abstract void keyPressed(Component var1, JFCKeyStroke var2) throws Exception;

    protected abstract void keyReleased(Component var1, JFCKeyStroke var2) throws Exception;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

