/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.util;

import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlHelper {
    private static DocumentBuilderFactory factory__ = DocumentBuilderFactory.newInstance();
    private static DocumentBuilder builder__;
    public static final String COMMENT = "Cm";
    public static final String NAME = "Nm";
    public static final String X = "x";
    public static final String Y = "y";
    public static final String W = "h";
    public static final String H = "w";
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\"";

    public static void ensureBuilder() {
        if (builder__ == null) {
            try {
                builder__ = factory__.newDocumentBuilder();
            }
            catch (Exception e) {
                LogUtil.printStackTrace(e);
            }
        }
    }

    public static Document getNewDocument() {
        return XmlHelper.getNewDocumentByJaxp();
    }

    private static Document getNewDocumentByJaxp() {
        XmlHelper.ensureBuilder();
        return builder__.newDocument();
    }

    public static String getStringFromElement(Element element) {
        String str = null;
        StringWriter strWriter = new StringWriter();
        try {
            DOMSource source = new DOMSource(element);
            StreamResult result = new StreamResult(strWriter);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
            str = strWriter.getBuffer().toString();
            strWriter.close();
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return str;
    }

    public static String getStrFromElmNoHeader(Element elm) {
        String rawXmlStr = XmlHelper.getStringFromElement(elm);
        int start = XML_HEADER.length() - 1;
        String strOut = rawXmlStr.substring(start);
        return strOut;
    }

    public static void writeElement(Element element, File file) throws Exception {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        try {
            DOMSource source = new DOMSource(element);
            StreamResult result = new StreamResult(file);
            TransformerFactory factory = TransformerFactory.newInstance();
            try {
                factory.setAttribute("indent-number", new Integer(3));
            }
            catch (Exception exception) {
                // empty catch block
            }
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            xformer.transform(source, result);
            Properties props = xformer.getOutputProperties();
            Enumeration<?> myEnum = props.propertyNames();
            while (myEnum.hasMoreElements()) {
                String propNm = (String)myEnum.nextElement();
                String string = props.getProperty(propNm);
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    public static void writeElement(Element element, Writer writer) throws IOException {
    }

    public static Document loadDocument(File file) {
        Document doc = null;
        String absPath = file.getAbsolutePath();
        try {
            XmlHelper.ensureBuilder();
            doc = builder__.parse(file);
        }
        catch (SAXException e) {
            LogUtil.logErr("SAXException: " + e.getMessage() + "\nOpening: " + absPath);
        }
        catch (Exception e) {
            LogUtil.logErr("Exception: " + e.getMessage() + "\nOpening: " + absPath);
        }
        return doc;
    }

    public static Document getDocFromString(String xmlAsString) {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            StringReader reader = new StringReader(xmlAsString);
            InputSource inputSource = new InputSource(reader);
            doc = builder.parse(inputSource);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return doc;
    }

    public static String stripNonValidXMLCharacters(String in, String objTypeNm, String objNm) {
        StringBuffer out = new StringBuffer();
        if (in == null || "".equals(in)) {
            return "";
        }
        for (int i = 0; i < in.length(); ++i) {
            char current = in.charAt(i);
            if (current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd' || current >= '\u10000' && current <= '\u10ffff') {
                out.append(current);
                continue;
            }
            LogUtil.logErr("XmlHelper.invalid.XML.char:" + current + "< value:" + current + ", at: " + i + ", in " + objTypeNm + " : " + objNm);
        }
        return out.toString();
    }

    public static Element createElementSimple(Document doc, String elementName, String elementValue) {
        if (elementValue == null) {
            LogUtil.logErr("XmlHelper.warning: ElementValue should NOT be null. May cause null pointer errors in XML transformer.");
        }
        Element element = doc.createElement(elementName);
        element.appendChild(doc.createTextNode(elementValue));
        return element;
    }

    public static Element createElementSimple(Document doc, String elementName, int elementValue) {
        return XmlHelper.createElementSimple(doc, elementName, Integer.toString(elementValue));
    }

    public static Element createElementSimple(Document doc, String elementName, boolean elementValue) {
        return XmlHelper.createElementSimple(doc, elementName, Boolean.toString(elementValue));
    }

    public static Element createElementSimple(Document doc, String elementName, double elementValue) {
        return XmlHelper.createElementSimple(doc, elementName, Double.toString(elementValue));
    }

    public static void addForeignElement(Document doc, Element parent, Element child) {
        try {
            Element elmImported = (Element)doc.importNode(child, true);
            parent.appendChild(elmImported);
        }
        catch (Exception e) {
            String msg = "XmlHelper.addForeignElement.error: " + e.getMessage();
            LogUtil.logMsg(msg);
        }
    }

    public static void appendChildSafe(Element parent, Element child) {
        try {
            parent.appendChild(child);
        }
        catch (Exception e) {
            String msg = "XmlHelper.appendChildSafe.error: " + e.getMessage();
            LogUtil.logMsg(msg);
        }
    }

    public static void addElementSimple(Document doc, Element parentElement, String childElementName, String childElementValue) {
        try {
            Element elmChild = XmlHelper.createElementSimple(doc, childElementName, childElementValue);
            parentElement.appendChild(elmChild);
        }
        catch (Exception e) {
            String msg = "XmlHelper.addElementSimple.childElementName: " + childElementName + ", childElementValue: " + childElementValue + ",\n error: " + e.getMessage();
            LogUtil.logMsg(msg);
        }
    }

    public static void addElementSimple(Document doc, Element parentElement, String childElementName, int childElementValue) {
        XmlHelper.addElementSimple(doc, parentElement, childElementName, Integer.toString(childElementValue));
    }

    public static void addElementSimple(Document doc, Element parentElement, String childElementName, boolean childElementValue) {
        XmlHelper.addElementSimple(doc, parentElement, childElementName, Boolean.toString(childElementValue));
    }

    public static void addElementSimple(Document doc, Element parentElement, String childElementName, double childElementValue) {
        XmlHelper.addElementSimple(doc, parentElement, childElementName, Double.toString(childElementValue));
    }

    public static Element getFirstElementByTagName(Element elmParent, String elementName) {
        Element elmFirst = null;
        NodeList nodes = elmParent.getElementsByTagName(elementName);
        if (nodes.getLength() > 0) {
            elmFirst = (Element)nodes.item(0);
        }
        return elmFirst;
    }

    public static Element getFirstElementByTagAndAttr(Element elmParent, String tagNm, String attrNm, String attrValue) {
        Element elmFound = null;
        NodeList nodes = elmParent.getElementsByTagName(tagNm);
        int nodeCount = nodes.getLength();
        for (int i = 0; i < nodeCount && elmFound == null; ++i) {
            Element elm = (Element)nodes.item(i);
            String foundValue = elm.getAttribute(attrNm);
            if (!foundValue.equals(attrValue)) continue;
            elmFound = elm;
        }
        return elmFound;
    }

    public static void setAttrNullable(Element element, String attrName, String attrValue) {
        if (attrValue != null) {
            element.setAttribute(attrName, attrValue);
        } else {
            element.setAttribute(attrName, "");
        }
    }

    public static String getAttrNullable(Element element, String attrName) {
        String attrValue = element.getAttribute(attrName);
        if (attrValue.equals("")) {
            return null;
        }
        return attrValue;
    }

    public static void setAttr(Element element, String attrName, boolean bool) {
        String str = Boolean.toString(bool);
        element.setAttribute(attrName, str);
    }

    public static void setAttr(Element element, String attrName, int i) {
        String str = Integer.toString(i);
        element.setAttribute(attrName, str);
    }

    public static void setAttr(Element element, String attrName, double i) {
        String str = Double.toString(i);
        element.setAttribute(attrName, str);
    }

    public static void setAttrBoolAsInt(Element element, String attrName, boolean bool) {
        int i = bool ? 1 : 0;
        String str = Integer.toString(i);
        element.setAttribute(attrName, str);
    }

    public static boolean getAttrBoolFromInt(Element element, String attrName) {
        int i = XmlHelper.getAttrInt(element, attrName);
        boolean bool = i != 0;
        return bool;
    }

    public static boolean getAttrValueBoolean(String attrStr) {
        return Boolean.valueOf(attrStr);
    }

    public static boolean getAttrBool(Element element, String attrName) {
        boolean bool = false;
        String attrStr = element.getAttribute(attrName);
        if (attrStr.length() > 0) {
            boolean isValid;
            boolean isTrueOrFalse = attrStr.equalsIgnoreCase("true") || attrStr.equalsIgnoreCase("false");
            boolean isTorF = attrStr.equalsIgnoreCase("t") || attrStr.equalsIgnoreCase("f");
            boolean bl = isValid = isTrueOrFalse || isTorF;
            if (!isValid) {
                LogUtil.logErr("Invalid Boolean Xml Attr, name: " + attrName + ", value: " + attrStr);
            }
            bool = Boolean.valueOf(attrStr);
        }
        return bool;
    }

    public static int getAttrInt(Element element, String attrName) {
        int i = 0;
        String str = element.getAttribute(attrName);
        try {
            i = Integer.parseInt(str);
        }
        catch (Exception e) {
            System.out.println("XmlHelper.getAttrInt(). Could not parse int: " + str);
        }
        return i;
    }

    public static void addRectAttrs(Element elmTag, Rectangle bounds) {
        XmlHelper.setAttr(elmTag, X, bounds.x);
        XmlHelper.setAttr(elmTag, Y, bounds.y);
        XmlHelper.setAttr(elmTag, W, bounds.width);
        XmlHelper.setAttr(elmTag, H, bounds.height);
    }

    public static Rectangle getRectFromAttrs(Element elm) {
        Rectangle bounds = new Rectangle(XmlHelper.getAttrInt(elm, X), XmlHelper.getAttrInt(elm, Y), XmlHelper.getAttrInt(elm, W), XmlHelper.getAttrInt(elm, H));
        return bounds;
    }

    public static String getFirstElementValue(Element elmParent, String elementName) {
        Element elmFirst = XmlHelper.getFirstElementByTagName(elmParent, elementName);
        if (elmFirst != null) {
            return XmlHelper.getElementValue(elmFirst);
        }
        return "";
    }

    public static String getElementValue(Element element) {
        StringBuffer text = new StringBuffer();
        Node firstChild = element.getFirstChild();
        if (firstChild != null && firstChild.getNodeType() == 3) {
            text.append(firstChild.getNodeValue());
        }
        return text.toString();
    }

    public static int getElementValueInt(Element element) {
        String textValue = XmlHelper.getElementValue(element);
        return Integer.valueOf(textValue);
    }

    public static boolean getElementValueBoolean(Element element) {
        String textValue = XmlHelper.getElementValue(element);
        return Boolean.valueOf(textValue);
    }

    public static double getElementValueDouble(Element element) {
        String textValue = XmlHelper.getElementValue(element);
        return Double.valueOf(textValue);
    }

    public static String getNameRectangle() {
        return "Rectangle";
    }

    public static Element asXml(Document doc, Rectangle rect) {
        return XmlHelper.asXml(doc, rect, null);
    }

    public static Element asXml(Document doc, Rectangle rect, String name) {
        String nameStr = name != null ? name : XmlHelper.getNameRectangle();
        Element element = doc.createElement(nameStr);
        XmlHelper.addElementSimple(doc, element, "X", rect.getX());
        XmlHelper.addElementSimple(doc, element, "Y", rect.getY());
        XmlHelper.addElementSimple(doc, element, "Width", rect.getWidth());
        XmlHelper.addElementSimple(doc, element, "Height", rect.getHeight());
        return element;
    }

    public static List<Element> getAsGenericsList(NodeList elements) {
        ArrayList<Element> list = new ArrayList<Element>();
        for (int i = 0; i < elements.getLength(); ++i) {
            Element elm = (Element)elements.item(i);
            list.add(elm);
        }
        return list;
    }

    public static void addConditionCommentElm(Document doc, Element elmParent, String commentStr) {
        if (Validator.isStringValid(commentStr)) {
            XmlHelper.addElementSimple(doc, elmParent, COMMENT, commentStr);
        }
    }

    public static String getConditionComment(Element elmParent) {
        Element elmComment = XmlHelper.getDirectChildElement(elmParent, COMMENT);
        String comment = elmComment != null ? XmlHelper.getElementValue(elmComment) : "";
        return comment;
    }

    public static Element getDirectChildElement(Element elmParent, String childNm) {
        NodeList children = elmParent.getChildNodes();
        Element elmFound = null;
        boolean found = false;
        for (int i = 0; i < children.getLength() && !found; ++i) {
            Element elmChild;
            Node node = children.item(i);
            if (!(node instanceof Element) || !(elmChild = (Element)node).getNodeName().equals(childNm)) continue;
            elmFound = elmChild;
            found = true;
        }
        return elmFound;
    }

    public static Rectangle fromXmlRectangle(Element element) {
        int x = (int)Double.parseDouble(XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, "X")));
        int y = (int)Double.parseDouble(XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, "Y")));
        int w = (int)Double.parseDouble(XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, "Width")));
        int h = (int)Double.parseDouble(XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, "Height")));
        return new Rectangle(x, y, w, h);
    }

    public static String getNameColor() {
        return "Color";
    }

    public static Element asXml(Document doc, Color color) {
        Element element = doc.createElement(XmlHelper.getNameColor());
        XmlHelper.addElementSimple(doc, element, "R", color.getRed());
        XmlHelper.addElementSimple(doc, element, "G", color.getGreen());
        XmlHelper.addElementSimple(doc, element, "B", color.getBlue());
        return element;
    }

    public static Color fromXmlColor(Element element) {
        int r = Integer.parseInt(XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, "R")));
        int g = Integer.parseInt(XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, "G")));
        int b = Integer.parseInt(XmlHelper.getElementValue(XmlHelper.getFirstElementByTagName(element, "B")));
        return new Color(r, g, b);
    }
}

