/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public final class Validator {
    private Validator() {
    }

    public static void checkVectorIndex(Vector v, int index) throws IllegalArgumentException {
        if (index < 0) {
            throw new IllegalArgumentException("The index must be a positive number.");
        }
        if (index >= v.size()) {
            throw new IllegalArgumentException("For this array the index must be less than " + v.size() + " but " + index + " was supplied.");
        }
    }

    public static boolean isStringValid(String str) {
        if (str != null) {
            return str.length() > 0;
        }
        return false;
    }

    public static void isStringEmpty(String evaluatedString, String errMsgVariablePortion) throws IllegalArgumentException {
        if (evaluatedString == null) {
            throw new IllegalArgumentException(Validator.getErrMsgNull(errMsgVariablePortion));
        }
        if (evaluatedString.length() < 1) {
            throw new IllegalArgumentException(Validator.getErrMsgEmptyString(errMsgVariablePortion));
        }
    }

    public static String getErrMsgEmptyString(String variablePortion) {
        return "The " + variablePortion + " can not be an empty string.";
    }

    public static String getErrMsgNull(String variablePortion) {
        return "The " + variablePortion + " can not be null.";
    }

    public static boolean isIntInRange(int value, int lowerLimit, int upperLimit) {
        boolean inRange = value >= lowerLimit && value <= upperLimit;
        return inRange;
    }

    public static void checkIntInRange(int value, int lowerLimit, int upperLimit, String name) throws IllegalArgumentException {
        if (!Validator.isIntInRange(value, lowerLimit, upperLimit)) {
            throw new IllegalArgumentException("The value for " + name + " must be between " + lowerLimit + " and " + upperLimit + " but " + value + " was supplied.");
        }
    }

    public static void checkCollectionValid(Collection coll, String variablePart) throws IllegalArgumentException {
        if (coll.size() <= 0) {
            throw new IllegalArgumentException("The " + variablePart + " collection can not be empty.");
        }
    }

    public static Object[] removeDups(Object[] mainArray, Object[] dupArray) {
        ArrayList<String> dupFree = new ArrayList<String>();
        for (int i = 0; i < mainArray.length; ++i) {
            String currentMain = mainArray[i].toString();
            boolean match = false;
            for (int j = 0; j < dupArray.length; ++j) {
                if (!currentMain.equals(dupArray[j].toString())) continue;
                match = true;
            }
            if (match) continue;
            dupFree.add(currentMain);
        }
        return dupFree.toArray();
    }

    public static String confirmRemoveMsg(String className, String objectName) {
        String msg = "Error building the error message.";
        if (className != null && objectName != null) {
            msg = "Are you sure want to remove the " + className + ": " + objectName + "?";
        }
        if (className == null && objectName != null) {
            msg = "Are you sure want to remove " + objectName + "?";
        }
        if (className != null && objectName == null) {
            msg = "Are you sure want to remove this " + className + "?";
        }
        if (className == null && objectName == null) {
            msg = "Are you sure want to perform this remove operation?";
        }
        return msg;
    }

    public static String confirmRemoveMsg(String className, int itemCount) {
        String msg = "Error building the error message.";
        msg = className != null ? "Are you sure want to remove these " + Integer.toString(itemCount) + " " + className + " objects?" : "Are you sure want to remove these " + Integer.toString(itemCount) + " objects?";
        return msg;
    }
}

