/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.util;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.util.OutputMgr;

public final class LogUtil {
    public static int TESTING_ID = 0;
    public static int PRODUCTION_ID;
    private static final int RUN_MODE;

    public static boolean isTestMode() {
        return RUN_MODE == TESTING_ID;
    }

    public static void logMsg(String msg) {
        if (LogUtil.isTestMode()) {
            System.out.println(msg);
            LogUtil.log(msg);
        }
    }

    public static void logMsg(Object objectWithError, String msg) {
        String className = objectWithError.getClass().getSimpleName();
        LogUtil.logMsg(className + " - " + msg);
    }

    public static void logErr(String msg) {
        System.out.println(msg);
        LogUtil.log(msg);
    }

    public static void logErr(Object objectWithError, String msg) {
        String className = objectWithError.getClass().getSimpleName();
        LogUtil.logErr(className + " - " + msg);
    }

    public static void logRevEngError(Exception ex, String metaCtrlNm, String objDesc) {
        StrHelper.throwProgExcept("");
        LogUtil.logErr(metaCtrlNm + " - Reverse Engineer Error - " + objDesc + ": " + ex.getMessage());
    }

    public static void printStackTrace(Exception ex) {
        ex.printStackTrace();
    }

    private static void log(String msg) {
        OutputMgr.getInstance().log(msg);
    }

    static {
        RUN_MODE = PRODUCTION_ID = 1;
    }
}

