/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.util;

import com.harrand.util.XmlHelper;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HtmlHelper {
    private Document doc_;
    private boolean useAltRows_ = false;
    private int rowIndex_ = 0;
    private int totalRows_ = 0;
    public static final int MIN_ROWS_TO_ALTERNATE = 6;
    public static final String META_STR = "meta";
    public static final String HTTP_EQUIV_STR = "http-equiv";
    public static final String CONTENT_TYPE_STR = "Content-Type";
    public static final String CONTENT_STR = "content";
    public static final String UTF8_STR = "text/html; charset=UTF-8";
    public static final String ALT_ROW = "altRow";
    public static final String INDEX_FILE_NM = "index.html";
    public static final String KEY_NM = "key";
    public static final String VALUE_NM = "value";
    public static final String PRE_STR = "pre";
    public static final String CLASS_STR = "class";
    public static final String PLAIN_STR = "plain";
    public static final String TD_STR = "td";
    public static final String TR_STR = "tr";
    public static final String COLSPAN_STR = "colspan";
    public static final String SPAN_STR = "span";
    public static final String BANNER_STR = "banner";
    public static final String TITLE_NM_STR = "title_nm";
    public static final String NONE_STR = "(none)";
    public static final String WATER_MARK_R_STR = "watermark_right";
    public static final String WATER_MARK_L_STR = "watermark_left";

    public void setDoc(Document doc) {
        this.doc_ = doc;
    }

    public static Document getHtmlDoc(String styleSheetRelPath, String title) {
        Document doc = XmlHelper.getNewDocument();
        Element elmHtml = doc.createElement("HTML");
        doc.appendChild(elmHtml);
        Element elmHeader = doc.createElement("Header");
        elmHtml.appendChild(elmHeader);
        XmlHelper.addElementSimple(doc, elmHeader, "Title", title);
        elmHeader.appendChild(HtmlHelper.getMetaElement(doc));
        if (styleSheetRelPath != null) {
            Element elmCss = doc.createElement("Link");
            elmCss.setAttribute("rel", "stylesheet");
            elmCss.setAttribute("href", styleSheetRelPath);
            elmCss.setAttribute("type", "text/css");
            elmHeader.appendChild(elmCss);
        }
        Element elmBody = doc.createElement("Body");
        elmHtml.appendChild(elmBody);
        return doc;
    }

    public static Element getBodyElement(Document doc) {
        Element elmDoc = doc.getDocumentElement();
        return XmlHelper.getFirstElementByTagName(elmDoc, "Body");
    }

    public void setRowAltProps(boolean useAltRows, int totalRows) {
        this.useAltRows_ = useAltRows;
        this.totalRows_ = totalRows;
        this.rowIndex_ = 0;
    }

    public static Element getMetaElement(Document doc) {
        Element elmMeta = doc.createElement(META_STR);
        elmMeta.setAttribute(HTTP_EQUIV_STR, CONTENT_TYPE_STR);
        elmMeta.setAttribute(CONTENT_STR, UTF8_STR);
        return elmMeta;
    }

    public Element getRowElement(List values, String tdClass) {
        Element elmRow = this.doc_.createElement(TR_STR);
        Element elmTd = null;
        for (Object obj : values) {
            elmTd = this.getVariableTdElm(obj, tdClass);
            elmRow.appendChild(elmTd);
        }
        this.setRowElmClassIfReq(elmRow);
        ++this.rowIndex_;
        return elmRow;
    }

    private void setRowElmClassIfReq(Element elmRow) {
        if (this.useAltRows_) {
            boolean isOddRow;
            boolean hasMinRows = this.totalRows_ >= 6;
            boolean bl = isOddRow = this.rowIndex_ % 2 == 1;
            if (hasMinRows && isOddRow) {
                elmRow.setAttribute(CLASS_STR, ALT_ROW);
            }
        }
    }

    public Element getVariableTdElm(Object value, String tdClass) {
        Element elmTd;
        boolean hasClassNm = false;
        if (value instanceof Element) {
            Element elmChild = (Element)value;
            String nodeNm = elmChild.getNodeName();
            if (nodeNm.equalsIgnoreCase(TD_STR)) {
                elmTd = elmChild;
            } else {
                elmTd = this.doc_.createElement(TD_STR);
                elmTd.appendChild(elmChild);
            }
            hasClassNm = elmTd.hasAttribute(CLASS_STR);
        } else if (value == null) {
            elmTd = XmlHelper.createElementSimple(this.doc_, TD_STR, " ");
        } else {
            String strObj = value.toString();
            String str = strObj.length() > 0 ? strObj : " ";
            elmTd = XmlHelper.createElementSimple(this.doc_, TD_STR, str);
        }
        if (!hasClassNm && tdClass != null) {
            elmTd.setAttribute(CLASS_STR, tdClass);
        }
        return elmTd;
    }

    public Element getKeyValueRowElm(String key, Object value) {
        Element elmRow = this.doc_.createElement(TR_STR);
        Element elmKey = XmlHelper.createElementSimple(this.doc_, TD_STR, key);
        elmRow.appendChild(elmKey);
        elmKey.setAttribute(CLASS_STR, KEY_NM);
        Element elmValue = this.doc_.createElement(TD_STR);
        elmRow.appendChild(this.getVariableTdElm(value, VALUE_NM));
        return elmRow;
    }

    public Element getAnchor(String display, String url, String className) {
        Element anchor = XmlHelper.createElementSimple(this.doc_, "a", display);
        if (className != null) {
            anchor.setAttribute(CLASS_STR, className);
        }
        anchor.setAttribute("href", url);
        return anchor;
    }

    public Element getPreElm(String text) {
        Element elm = XmlHelper.createElementSimple(this.doc_, PRE_STR, text);
        return elm;
    }

    public Element getImageElm(String src, String className) {
        Element elm = this.doc_.createElement("img");
        if (className != null) {
            elm.setAttribute(CLASS_STR, className);
        }
        elm.setAttribute("src", src);
        return elm;
    }

    public Element getBooleanImageElm(String imageSrc, boolean bool) {
        Element elmP = null;
        if (bool) {
            elmP = this.doc_.createElement("p");
            elmP.setAttribute(CLASS_STR, "boolImg");
            Element elmImg = this.getImageElm(imageSrc, null);
            elmP.appendChild(elmImg);
        }
        return elmP;
    }

    public Element getBoolImgHorzElm(String imageSrc, boolean bool) {
        Element elmP = null;
        if (bool) {
            elmP = this.doc_.createElement("p");
            elmP.setAttribute(CLASS_STR, "boolImgHorz");
            Element elmImg = this.getImageElm(imageSrc, null);
            elmP.appendChild(elmImg);
        }
        return elmP;
    }

    public Element getBannerRow(String display, int colSpan) {
        Element elmRow = this.doc_.createElement(TR_STR);
        Element elmCol = XmlHelper.createElementSimple(this.doc_, TD_STR, display);
        elmRow.appendChild(elmCol);
        elmCol.setAttribute(CLASS_STR, BANNER_STR);
        elmCol.setAttribute(COLSPAN_STR, Integer.toString(colSpan));
        return elmRow;
    }

    public Element getBannerRow(String objNm, String objType) {
        Element elmName = XmlHelper.createElementSimple(this.doc_, TD_STR, objNm);
        elmName.setAttribute(CLASS_STR, TITLE_NM_STR);
        Element elmType = XmlHelper.createElementSimple(this.doc_, TD_STR, "(" + objType + ")");
        elmType.setAttribute(CLASS_STR, WATER_MARK_R_STR);
        ArrayList<Element> items = new ArrayList<Element>();
        items.add(elmName);
        items.add(elmType);
        Element elmRow = this.getRowElement(items, "pageTitle");
        elmRow.setAttribute(CLASS_STR, BANNER_STR);
        return elmRow;
    }

    public Element getNoneGrid(Document doc, String objTypeNm) {
        this.setDoc(doc);
        Element elmGrid = doc.createElement("table");
        elmGrid.setAttribute(CLASS_STR, "flat");
        Element elmRow = this.doc_.createElement(TR_STR);
        elmGrid.appendChild(elmRow);
        Element elmCol = XmlHelper.createElementSimple(this.doc_, TD_STR, objTypeNm);
        elmCol.setAttribute(CLASS_STR, BANNER_STR);
        elmCol.setAttribute(COLSPAN_STR, "1");
        elmRow.appendChild(elmCol);
        Element elmPlain = XmlHelper.createElementSimple(this.doc_, SPAN_STR, " (none)");
        elmPlain.setAttribute(CLASS_STR, PLAIN_STR);
        elmCol.appendChild(elmPlain);
        return elmGrid;
    }
}

