/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.util;

import com.harrand.util.FileIO;
import com.harrand.util.LogUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ResourceBundle;

public final class FileHelper {
    private static ResourceBundle rb__ = FileHelper.getResourceBundleCommon();

    public static void saveStringToFile(String scriptText, String filePath) {
        File file = new File(filePath);
        FileHelper.saveStringToFile(scriptText, file);
    }

    public static void saveStringToFile(String scriptText, File file) {
        try {
            file.getParentFile().mkdirs();
            FileIO.stringToFile(scriptText, file.getPath());
        }
        catch (IOException e) {
            LogUtil.printStackTrace(e);
        }
    }

    public static String readFileToString(String filePath) {
        String str = "";
        try {
            str = FileHelper.readFileToString(new FileReader(filePath));
        }
        catch (IOException e) {
            LogUtil.printStackTrace(e);
        }
        return str;
    }

    public static String readFileToString(File file) {
        String str = "";
        try {
            str = FileHelper.readFileToString(new FileReader(file));
        }
        catch (IOException e) {
            LogUtil.printStackTrace(e);
        }
        return str;
    }

    public static String readFileToString(FileReader reader) {
        String str = "";
        try {
            str = FileIO.readerToString(reader);
            reader.close();
        }
        catch (IOException e) {
            LogUtil.printStackTrace(e);
        }
        return str;
    }

    public static void writeBytes(OutputStream outStream, byte[] bytes) throws Exception {
        outStream.write(bytes);
        outStream.flush();
        outStream.close();
    }

    public static byte[] readBytes(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        byte[] bytes = null;
        int n = fis.available();
        if (n > 0) {
            bytes = new byte[n];
            int n2 = fis.read(bytes);
        }
        fis.close();
        return bytes;
    }

    public static File getFile(File baseFolder, String relativePath) {
        return new File(baseFolder.getAbsolutePath() + "/" + relativePath);
    }

    public static String readFileResource(String path) {
        StringBuffer sb = new StringBuffer();
        try {
            String thisLine;
            InputStream is = sb.getClass().getResourceAsStream(path);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            while ((thisLine = br.readLine()) != null) {
                sb.append(thisLine);
                System.out.println(thisLine);
            }
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
        return sb.toString();
    }

    public static void copy(InputStream in, File dst) throws IOException {
        int len;
        dst.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileHelper.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static void deleteIfExists(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    public static ResourceBundle getResourceBundleCommon() {
        return ResourceBundle.getBundle("com.harrand.constants.Common");
    }

    public static String getResourceStringCommon(String key) {
        return rb__.getString(key);
    }

    public static String getResource(String key) {
        return FileHelper.getResourceStringCommon(key);
    }

    public static String getRes(String key) {
        return FileHelper.getResourceStringCommon(key);
    }

    public static String getResUnkown(String key) {
        String str = null;
        try {
            str = FileHelper.getRes(key);
        }
        catch (Exception e1) {
            LogUtil.printStackTrace(e1);
            try {
                LogUtil.logErr("Resource: '" + key + "' not in Constants.");
                str = "[app.getRes().fail]";
            }
            catch (Exception e2) {
                LogUtil.logErr("Could not find resource for: " + key);
            }
        }
        return str;
    }
}

