/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.zoom.presets;

import com.harrand.coreclasses.xml.abstractions.IXmlable;
import com.harrand.sketch.zoom.presets.ZoomPresetsCtrl;
import com.harrand.util.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ZoomPresetsXmlCtrl
implements IXmlable {
    private ZoomPresetsCtrl presetsCtrl = ZoomPresetsCtrl.getInstance();
    public static final String PRESETS_XML_NM = "zmPresets";
    public static final String PRESET_XML_NM = "preset";

    @Override
    public Element asXmlElement() {
        Document doc = XmlHelper.getNewDocument();
        Element elmPresets = doc.createElement(PRESETS_XML_NM);
        for (Integer preset : this.presetsCtrl.getPresets()) {
            Element elmPreset = XmlHelper.createElementSimple(doc, PRESET_XML_NM, preset);
            elmPresets.appendChild(elmPreset);
        }
        return elmPresets;
    }

    public void loadPresetsFromXml(Element elmParent) {
        Element elmPresets = XmlHelper.getFirstElementByTagName(elmParent, PRESETS_XML_NM);
        if (elmPresets != null) {
            this.presetsCtrl.removeAll();
            NodeList elms = elmPresets.getElementsByTagName(PRESET_XML_NM);
            for (int i = 0; i < elms.getLength(); ++i) {
                Element elm = (Element)elms.item(i);
                int preset = XmlHelper.getElementValueInt(elm);
                this.presetsCtrl.addPreset(preset);
            }
        }
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void setName(String newName) {
    }
}

