/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.zoom.presets;

import com.harrand.coreclasses.security.IUser;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ZoomPresetsCtrl {
    private static final ZoomPresetsCtrl instance = new ZoomPresetsCtrl();
    private Set<Integer> presets = new TreeSet<Integer>();
    private final int[] defaultPresets = new int[]{10, 25, 50, 75, 100, 125, 150};
    private IUser user;

    private ZoomPresetsCtrl() {
        this.loadDefaultPresets();
    }

    public static ZoomPresetsCtrl getInstance() {
        return instance;
    }

    public void addPreset(int percent) {
        this.presets.add(percent);
        this.save();
    }

    public void removePreset(int percent) {
        if (percent != 100) {
            this.presets.remove(percent);
            this.save();
        }
    }

    public List<Integer> getPresets() {
        return new ArrayList<Integer>(this.presets);
    }

    public void setUser(IUser user) {
        this.user = user;
    }

    void removeAll() {
        this.clear();
        this.save();
    }

    public double[] getRatios() {
        double[] ratios = new double[this.presets.size()];
        int i = 0;
        for (Integer preset : this.presets) {
            double ratio = (double)preset.intValue() / 100.0;
            ratios[i++] = ratio;
        }
        return ratios;
    }

    private void loadDefaultPresets() {
        this.clear();
        for (int i = 0; i < this.defaultPresets.length; ++i) {
            this.presets.add(this.defaultPresets[i]);
        }
    }

    private void clear() {
        this.presets = new TreeSet<Integer>();
    }

    private void save() {
        if (this.user != null) {
            this.user.save();
        }
    }
}

