/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.zoom.disp;

import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.panel.viewport.ViewportMoveCtrl;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.j2d.DiagramPanel;
import com.harrand.sketch.zoom.ZoomCtrlMgr;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.JScrollPane;

public final class SetZoomDisp {
    private DiagramPanel diagramPanel;
    private JScrollPane scrollPane;
    private ZoomCtrlMgr zmCtrlMgr = new ZoomCtrlMgr(LookupUtil.getLookupDb());

    public SetZoomDisp(DiagramPanel diagramPanel, JScrollPane scrollPane) {
        this.diagramPanel = diagramPanel;
        this.scrollPane = scrollPane;
    }

    public void setZoom(Zoom zoom) {
        if (this.getDiagram() != null) {
            Diagram diagram = this.getDiagram();
            double newZmLevel = zoom.getLevel();
            Rectangle vpRect = this.scrollPane.getViewport().getViewRect();
            Rectangle2D.Double rect2D = new Rectangle2D.Double(vpRect.getX(), vpRect.getY(), vpRect.getWidth(), vpRect.getHeight());
            Rectangle2D newRect = this.zmCtrlMgr.getZoomedRect(this.getDiagram(), newZmLevel, rect2D);
            Point rawOrigin = new Point((int)newRect.getX(), (int)newRect.getY());
            this.diagramPanel.drawBlank();
            this.diagramPanel.refresh();
            this.zmCtrlMgr.setZoomingInProgress(this.getDiagram(), true);
            diagram.setSuppressPaint(true);
            diagram.setZoom(zoom);
            ViewportMoveCtrl vpMoveCtrl = new ViewportMoveCtrl(this.scrollPane.getViewport());
            vpMoveCtrl.moveViewDirectly(rawOrigin);
            diagram.setSuppressPaint(false);
            this.zmCtrlMgr.setZoomingInProgress(this.getDiagram(), false);
        }
    }

    private Diagram getDiagram() {
        return this.diagramPanel.getDiagram();
    }
}

