/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.xml.svg.bldr.glyph;

import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.xml.svg.bldr.basic.SvgArcBldr;
import com.harrand.sketch.xml.svg.bldr.basic.SvgCircleBldr;
import com.harrand.sketch.xml.svg.bldr.basic.SvgLineBldr;
import com.harrand.sketch.xml.svg.bldr.basic.SvgPolygonBldr;
import com.harrand.sketch.xml.svg.bldr.basic.SvgRectBldr;
import com.harrand.util.LogUtil;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgEnhancedShapeBldr {
    private final Document doc;
    private final SvgLineBldr lineBldr;
    private final SvgArcBldr arcBldr;
    private final SvgCircleBldr circleBldr;
    private final SvgRectBldr rectBldr;
    private final SvgPolygonBldr polyBldr;

    public SvgEnhancedShapeBldr(Document doc) {
        this.doc = doc;
        this.lineBldr = new SvgLineBldr(this.doc);
        this.arcBldr = new SvgArcBldr(this.doc);
        this.circleBldr = new SvgCircleBldr(this.doc);
        this.rectBldr = new SvgRectBldr(this.doc);
        this.polyBldr = new SvgPolygonBldr(this.doc);
    }

    public Element buildElm(EnhancedShape eShape) {
        Shape shape = eShape.getShape();
        Color strokeColor = eShape.getStrokeColor();
        Color fillColor = eShape.getFillColor();
        LogUtil.logMsg("svgEnhancedShapeBuilder");
        if (shape instanceof Line2D) {
            return this.lineBldr.buildElm(eShape);
        }
        if (shape instanceof Arc2D) {
            return this.arcBldr.buildElm((Arc2D)shape, strokeColor);
        }
        if (shape instanceof Ellipse2D) {
            return this.circleBldr.buildElm((Ellipse2D)shape, strokeColor, fillColor);
        }
        if (shape instanceof RoundRectangle2D) {
            return this.rectBldr.buildElmFromRoundRect(eShape, null);
        }
        if (shape instanceof Rectangle2D) {
            return this.rectBldr.buildElmFromSquaredRect(eShape, null);
        }
        if (shape instanceof Polygon) {
            return this.polyBldr.buildElm((Polygon)shape, strokeColor, fillColor);
        }
        LogUtil.logErr("SvgEnhancedShapeBldr unrecognized shape: " + shape.getClass().getName());
        return null;
    }
}

