/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.xml.svg.bldr.basic;

import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.core.GlyphSeperator;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.xml.svg.common.SvgUtil;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Line2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgLineBldr {
    private Document doc;
    public static final String LINE_NM = "line";

    public SvgLineBldr(Document doc) {
        this.doc = doc;
    }

    public Element buildElm(GlyphSeperator sepGlyph) {
        Point coord = sepGlyph.getCoordSpace();
        Line2D line = sepGlyph.getLine();
        Line2D translatedLine = GeometryHelper.move(line, (double)coord.x, (double)coord.y);
        EnhancedShape eShape = new EnhancedShape(translatedLine);
        eShape.setStrokeColor(sepGlyph.getColor());
        Element elm = this.buildElm(eShape);
        return elm;
    }

    public Element buildElm(EnhancedShape eShape) {
        Line2D line = (Line2D)eShape.getShape();
        Line2D extendedLine = GeometryHelper.extendLine(line, 0.5);
        Element elm = XmlHelper.createElementSimple(this.doc, LINE_NM, "");
        XmlHelper.setAttr(elm, "x1", extendedLine.getX1());
        XmlHelper.setAttr(elm, "y1", extendedLine.getY1());
        XmlHelper.setAttr(elm, "x2", extendedLine.getX2());
        XmlHelper.setAttr(elm, "y2", extendedLine.getY2());
        this.addColorAttr(elm, eShape.getStrokeColor());
        this.addDashAttr(elm, eShape.getIsDashed());
        return elm;
    }

    private void addColorAttr(Element elm, Color strokeColor) {
        elm.setAttribute("style", SvgUtil.getStrokeColorStr(strokeColor));
    }

    private void addDashAttr(Element elm, boolean isDashed) {
        if (isDashed) {
            elm.setAttribute("stroke-dasharray", "3, 2");
        }
    }
}

