/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.xml.svg.bldr.basic;

import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.xml.svg.common.SvgUtil;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SvgArcBldr {
    private Document doc;
    public static final String PATH_NM = "path";

    public SvgArcBldr(Document doc) {
        this.doc = doc;
    }

    public Element buildElm(Arc2D arc, Color color) {
        Element elm = XmlHelper.createElementSimple(this.doc, PATH_NM, "");
        elm.setAttribute("d", this.getDString(arc));
        elm.setAttribute("style", this.getStyleValue(color));
        return elm;
    }

    private String getStyleValue(Color color) {
        return SvgUtil.getStrokeColorStr(color) + ";" + "fill:none";
    }

    private String getDString(Arc2D arc) {
        StringBuilder dStrBldr = new StringBuilder();
        Point2D start = arc.getStartPoint();
        Point2D end = arc.getEndPoint();
        int radius = GeometryHelper.getArcRadius(arc);
        dStrBldr.append("M").append(this.dToStr(start.getX())).append(",").append(this.dToStr(start.getY()));
        dStrBldr.append(" A").append(radius).append(",").append(radius);
        dStrBldr.append(" 0 0,0");
        dStrBldr.append(" ").append(this.dToStr(end.getX())).append(",").append(this.dToStr(end.getY()));
        return dStrBldr.toString();
    }

    private String dToStr(Double dbl) {
        return Double.toString(dbl);
    }
}

