/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.xml;

import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.sketch.core.VerbosityConfig;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VbConfigXmlCtrl
implements IXmlCtrl {
    public static final String VB_CFG = "VbCfg";
    public static final String FLAG = "Fg";
    public static final String KEY = "ky";
    public static final String VALUE = "vl";

    public Element asXmlElement(Document doc, VerbosityConfig vb) {
        Element elmVbCfg = doc.createElement(VB_CFG);
        TreeMap map = vb.getShowFlagsMap();
        for (String key : map.keySet()) {
            boolean show = (Boolean)map.get(key);
            Element elmFlag = doc.createElement(FLAG);
            elmFlag.setAttribute(KEY, key);
            XmlHelper.setAttrBoolAsInt(elmFlag, VALUE, show);
            elmVbCfg.appendChild(elmFlag);
        }
        return elmVbCfg;
    }

    public VerbosityConfig fromXml(Element element) {
        TreeMap<String, Boolean> map = new TreeMap<String, Boolean>();
        String tagName = FLAG;
        NodeList list = element.getElementsByTagName(tagName);
        for (int i = 0; i < list.getLength(); ++i) {
            Element elmFlag = (Element)list.item(i);
            String key = elmFlag.getAttribute(KEY);
            boolean value = XmlHelper.getAttrBoolFromInt(elmFlag, VALUE);
            map.put(key, new Boolean(value));
        }
        VerbosityConfig newVbCfg = null;
        try {
            newVbCfg = new VerbosityConfig(map);
        }
        catch (Exception e) {
            LogUtil.logErr("VerbosityConfigXmlCtr.fromXml.error: " + e.getMessage());
        }
        return newVbCfg;
    }
}

