/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.xml;

import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.core.VerbosityConfig;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.sketch.linkStrategies.OffsetDirect;
import com.harrand.sketch.xml.LinkStrategyXmlParser;
import com.harrand.sketch.xml.VbConfigXmlCtrl;
import com.harrand.util.LogUtil;
import com.harrand.util.XmlHelper;
import java.awt.Font;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RenderConfigXmlCtrl {
    private VbConfigXmlCtrl vbCfgCtrl_ = new VbConfigXmlCtrl();
    public static final String CLICK_ACTION_STR = "ClkAct";
    public static final String RENDER_CFG = "RnCf";
    public static final String ZOOM = "zm";
    public static final String LINK_STRATEGY = "lkStgy";
    public static final String FONT_SIZE = "FtSz";

    public Element asXmlElement(Document doc, RenderConfig rc) {
        Element elmRc = doc.createElement(RENDER_CFG);
        Zoom zoom = rc.getZoom();
        String zmStr = Double.toString(zoom.getLevel());
        elmRc.setAttribute(ZOOM, zmStr);
        XmlHelper.setAttr(elmRc, FONT_SIZE, rc.getFont().getSize());
        elmRc.setAttribute(LINK_STRATEGY, rc.getLinkStrategy().getName());
        XmlHelper.setAttr(elmRc, CLICK_ACTION_STR, rc.getClickActionsOn());
        VerbosityConfig vbCfg = rc.getVerbosityConfig();
        Element elmVbCfg = this.vbCfgCtrl_.asXmlElement(doc, vbCfg);
        elmRc.appendChild(elmVbCfg);
        return elmRc;
    }

    public RenderConfig fromXml(Element element) {
        String zmStr = element.getAttribute(ZOOM);
        Element elmVbCfg = XmlHelper.getFirstElementByTagName(element, "VbCfg");
        VerbosityConfig vbCfg = this.vbCfgCtrl_.fromXml(elmVbCfg);
        int fontSize = XmlHelper.getAttrInt(element, FONT_SIZE);
        boolean clickActionsOn = this.getClickActionFlag(element);
        RenderConfig newRc = null;
        try {
            double zmLevel = Double.parseDouble(zmStr);
            newRc = new RenderConfig(zmLevel, (LinkStrategy)new OffsetDirect(), vbCfg);
            LinkStrategy strategy = this.getLinkStrategy(element);
            newRc.setLinkStrategy(strategy);
            String family = "Verdana";
            Font font = new Font(family, 0, fontSize);
            newRc.setFont(font);
            newRc.setClickActionsOn(clickActionsOn);
        }
        catch (Exception e) {
            LogUtil.logErr("VerbosityConfigXmlCtr.fromXml.error: " + e.getMessage());
        }
        return newRc;
    }

    private LinkStrategy getLinkStrategy(Element element) {
        String linkStrategryNm = element.getAttribute(LINK_STRATEGY);
        LinkStrategy strategy = new LinkStrategyXmlParser().parseLinkStrategy(linkStrategryNm);
        return strategy;
    }

    private boolean getClickActionFlag(Element elmRc) {
        boolean clickActionFlag = true;
        String attrStr = elmRc.getAttribute(CLICK_ACTION_STR);
        if (attrStr.length() == 0) {
            return clickActionFlag;
        }
        clickActionFlag = XmlHelper.getAttrBool(elmRc, CLICK_ACTION_STR);
        return clickActionFlag;
    }
}

