/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.xml;

import com.harrand.coreclasses.display.BasicColorable;
import com.harrand.coreclasses.xml.IXmlCtrl;
import com.harrand.sketch.object.Note;
import com.harrand.util.XmlHelper;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NoteXmlCtrl
implements IXmlCtrl {
    public static final String NOTES = "Notes";
    public static final String NOTE = Note.getClassName();
    private static final String X = "x";
    private static final String Y = "y";

    public Element asXmlElement(Document doc, List<Note> notes) {
        Element elmNotes = doc.createElement(NOTES);
        for (Note note : notes) {
            Element elmNote = XmlHelper.createElementSimple(doc, NOTE, note.getText());
            Point origin = note.getOrigin();
            XmlHelper.setAttr(elmNote, X, origin.x);
            XmlHelper.setAttr(elmNote, Y, origin.y);
            Color bkColor = note.getColor();
            elmNote.setAttribute("bkCl", Integer.toHexString(bkColor.getRGB()));
            elmNotes.appendChild(elmNote);
        }
        return elmNotes;
    }

    public static List<Note> fromXml(Element elmNotes) {
        ArrayList<Note> notes = new ArrayList<Note>();
        NodeList elms = elmNotes.getElementsByTagName(NOTE);
        for (int i = 0; i < elms.getLength(); ++i) {
            Element elm = (Element)elms.item(i);
            String text = XmlHelper.getElementValue(elm);
            Point origin = new Point(XmlHelper.getAttrInt(elm, X), XmlHelper.getAttrInt(elm, Y));
            Color color = BasicColorable.fromXmlHexString(elm, "bkCl");
            Note note = new Note(text, origin);
            note.setColor(color);
            notes.add(note);
        }
        return notes;
    }
}

