/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.support;

import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coreclasses.zoom.Zoomer;
import com.harrand.sketch.core.Glyph;
import com.harrand.sketch.glyph.AnchorGlyph;
import com.harrand.sketch.interfaces.IResizableGlyph;
import java.awt.Point;
import java.awt.Rectangle;

public class GlyphResizeCtrl {
    private AnchorGlyph activeAnchor;

    public boolean isActive() {
        return this.hasActiveAnchor();
    }

    public void clear() {
        this.activeAnchor = null;
    }

    private boolean hasActiveAnchor() {
        boolean isActive = this.activeAnchor != null;
        return isActive;
    }

    public boolean checkAnchorActivated(Glyph clickedGlyph, Point mousePt, Zoom zoom) {
        if (this.hasActiveAnchor()) {
            return true;
        }
        if (clickedGlyph == null) {
            return false;
        }
        if (clickedGlyph instanceof IResizableGlyph) {
            IResizableGlyph resizableGlyph = (IResizableGlyph)((Object)clickedGlyph);
            Point diagramPt = this.getDiagramPt(mousePt, zoom);
            this.activeAnchor = resizableGlyph.getSelectedAnchor(diagramPt);
        }
        return this.hasActiveAnchor();
    }

    public void resizeGlyph(Glyph firstGlyph, Point mousePt, Zoom zoom) {
        boolean isResizableGlyph = firstGlyph instanceof IResizableGlyph;
        if (this.hasActiveAnchor() && isResizableGlyph) {
            IResizableGlyph resizableGlyph = (IResizableGlyph)((Object)firstGlyph);
            Point diagramPt = this.getDiagramPt(mousePt, zoom);
            Rectangle resizeRect = resizableGlyph.getResizeRect(this.activeAnchor, diagramPt);
            resizableGlyph.resize(resizeRect);
        }
    }

    private Point getDiagramPt(Point mousePt, Zoom zoom) {
        return Zoomer.unZoom(mousePt, zoom.getLevel());
    }
}

