/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.relation.panel;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.dbwrench.diagram.relation.notation.erNotation.DbwErNotationFactory;
import com.harrand.sketch.relation.notation.erNotation.IErNotation;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ErNotationSelectPanel
extends JPanel {
    private DbwErNotationFactory factory = DbwErNotationFactory.getInstance();
    private JLabel lbl = new JLabel("Entity Relation Notation");
    private JComboBox cboNotations;
    private ComboBoxModel model;
    private final IErNotation notation;

    public ErNotationSelectPanel(IErNotation notation) {
        this.notation = notation;
        this.init();
    }

    public IErNotation getErNotation() {
        return (IErNotation)this.cboNotations.getSelectedItem();
    }

    public void loadOptMgrSettings() {
        IErNotation optionNotation = this.factory.getOptionMgrNotation();
        if (optionNotation != null) {
            this.model.setSelectedItem(optionNotation);
        }
    }

    private void createComboBox() {
        ArrayList<IErNotation> notations = this.factory.getNotations();
        Vector<IErNotation> notationVector = new Vector<IErNotation>(notations);
        this.model = new DefaultComboBoxModel<IErNotation>(notationVector);
        this.cboNotations = new JComboBox(this.model);
        this.model.setSelectedItem(this.notation);
    }

    private void init() {
        this.setupGui();
    }

    private void setupGui() {
        this.createComponents();
        this.layoutComponents();
        this.setCosmetics();
    }

    private void layoutComponents() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(GuiHelper.getLeftAlignedPanel(this.cboNotations));
        this.add(Box.createVerticalGlue());
    }

    private void setCosmetics() {
        GuiHelper.setTitledBorderBuffered(this, "Entity Relation (ER) Notation");
        this.cboNotations.setPrototypeDisplayValue("Information Engineering00000000");
    }

    private void createComponents() {
        this.createComboBox();
    }
}

