/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.relation.line.move;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.relation.edge.EdgeLimitCalc;
import com.harrand.sketch.relation.edge.EdgeLimitResult;
import com.harrand.sketch.relation.line.LineRole;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.line.move.BaseLineMoveChecker;
import com.harrand.sketch.relation.rect.LinkRect;
import java.awt.geom.Point2D;

public final class BoxedLineMoveChecker
extends BaseLineMoveChecker {
    private final EdgeLimitCalc edgeLimitCalc = new EdgeLimitCalc();
    private EdgeLimitResult edgeLimitResult;
    private boolean isSingleConnectingLine;

    public boolean isLinkTransitioned(BoxLink boxLink, PositionableLine line, Point2D referencePt) {
        this.doLineUpdate = false;
        return this.setLineAfterChecking(boxLink, line, referencePt);
    }

    public boolean setLineAfterChecking(BoxLink boxLink, PositionableLine line, Point2D referencePt) {
        this.line = line;
        this.referencePt = referencePt;
        this.boxLink = boxLink;
        this.wasAnIncursion = false;
        this.lineBox = line.getRects(boxLink)[0];
        this.setNotLineBox();
        return this.moveLineDisp();
    }

    private boolean moveLineDisp() {
        double coordinate;
        this.isSingleConnectingLine = this.line.getLineRole().equals((Object)LineRole.SINGLE_LINE);
        if (this.line.isVerticalLine()) {
            coordinate = this.referencePt.getX();
            this.checkXLimits(coordinate);
            if (!EdgeLimitResult.EXCEEDS_BOUNDRY.equals((Object)this.edgeLimitResult) && this.doLineUpdate) {
                this.line.setAbsX(this.boxLink, coordinate);
            }
        }
        if (this.line.isHorizontalLine()) {
            coordinate = this.referencePt.getY();
            this.checkYLimits(coordinate);
            if (!EdgeLimitResult.EXCEEDS_BOUNDRY.equals((Object)this.edgeLimitResult) && this.doLineUpdate) {
                this.line.setAbsY(this.boxLink, coordinate);
            }
        }
        if (!LineRole.SINGLE_LINE.equals((Object)this.line.getLineRole())) {
            this.wasAnIncursion = this.calcBoxIncursion();
        }
        if (this.getEdgeSwitchDueToEdgeLimitRequired() || this.wasAnIncursion) {
            this.switchEdgeDispatcher.switchEdge(this.boxLink, this.transitionedBox, this.otherBox, this.edgeLimitResult, this.wasAnIncursion);
            return true;
        }
        return false;
    }

    private void checkXLimits(double x) {
        if (!this.line.isBoxEdgeLimited()) {
            this.edgeLimitResult = EdgeLimitResult.WITHIN_EDGE_LIMITS;
            return;
        }
        this.edgeLimitResult = this.edgeLimitCalc.testXLimit(this.lineBox, x, this.notLineBox);
        this.checkSetTransitionedBoxIfEdgeLimitExceeded(this.lineBox, this.notLineBox);
        if (this.isWithinLimits() && this.isSingleConnectingLine) {
            this.edgeLimitResult = this.edgeLimitCalc.testXLimit(this.notLineBox, x, this.lineBox);
            this.checkSetTransitionedBoxIfEdgeLimitExceeded(this.notLineBox, this.lineBox);
        }
    }

    private void checkYLimits(double y) {
        if (!this.line.isBoxEdgeLimited() || this.line.isZeroLength()) {
            this.edgeLimitResult = EdgeLimitResult.WITHIN_EDGE_LIMITS;
            return;
        }
        this.edgeLimitResult = this.edgeLimitCalc.testYLimit(this.lineBox, y, this.notLineBox);
        this.checkSetTransitionedBoxIfEdgeLimitExceeded(this.lineBox, this.notLineBox);
        if (this.isWithinLimits() && this.isSingleConnectingLine) {
            this.edgeLimitResult = this.edgeLimitCalc.testYLimit(this.notLineBox, y, this.lineBox);
            this.checkSetTransitionedBoxIfEdgeLimitExceeded(this.notLineBox, this.lineBox);
        }
    }

    private boolean isWithinLimits() {
        return this.edgeLimitResult.equals((Object)EdgeLimitResult.WITHIN_EDGE_LIMITS);
    }

    private void checkSetTransitionedBoxIfEdgeLimitExceeded(LinkRect testRect, LinkRect notTestRect) {
        if (this.getEdgeSwitchDueToEdgeLimitRequired()) {
            this.transitionedBox = testRect;
            this.otherBox = notTestRect;
        }
    }

    private boolean getEdgeSwitchDueToEdgeLimitRequired() {
        return EdgeLimitResult.NEEDS_EDGE_SWITCH_LOWER.equals((Object)this.edgeLimitResult) || EdgeLimitResult.NEEDS_EDGE_SWITCH_HIGHER.equals((Object)this.edgeLimitResult);
    }

    private void setNotLineBox() {
        LinkRect parentRect = this.boxLink.getBox(this.boxLink.getParentBoxName());
        LinkRect childRect = this.boxLink.getBox(this.boxLink.getChildBoxName());
        this.notLineBox = parentRect.equals(this.lineBox) ? childRect : parentRect;
    }
}

