/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.relation.joint;

import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.notification.lite.BasicObservableLite;
import com.harrand.coreclasses.notification.lite.IObservableLite;

public final class JointDimensionCalc
implements IObservableLite {
    private final BasicObservableLite observableLite = new BasicObservableLite();
    private double fontScaleFactor;
    private int circleRadius;
    private int diameter;
    private double backBoneLength;
    private double offset;
    private static final int BACKBONE_OFFSET = 3;
    private static final int BACKBONE_COEFFICIENT = 3;
    private static final int RADIUS_OFFSET = 1;
    private static final int RADIUS_COEFFICIENT = 3;
    private static final int OFFSET_COEFFICIENT = 8;

    public JointDimensionCalc(double fontScaleFactor) {
        this.setFontScaleFactor(fontScaleFactor);
    }

    private void refreshDimensions() {
        this.offset = 8.0 * this.fontScaleFactor;
        this.circleRadius = (int)(3.0 * this.fontScaleFactor) + 1;
        this.diameter = 2 * this.circleRadius;
        this.backBoneLength = this.offset + 3.0 + (double)(3 * this.circleRadius);
    }

    public void setFontScaleFactor(double fontScaleFactor) {
        this.fontScaleFactor = fontScaleFactor;
        this.refreshDimensions();
    }

    public double getLength() {
        return this.getBackBoneLength();
    }

    public double getHeight() {
        return this.diameter;
    }

    public double getBackBoneLength() {
        return this.backBoneLength;
    }

    public int getCircleRadius() {
        return this.circleRadius;
    }

    public int getDiameter() {
        return this.diameter;
    }

    public double getOffset() {
        return this.offset;
    }

    public double getScaleFactor() {
        return this.fontScaleFactor;
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observableLite.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        this.observableLite.notifyObservers(chain);
    }
}

