/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.relation.glyph;

import com.harrand.coreclasses.element.Cardinality;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.core.IJoint;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.linkStrategies.LinkStrategy;
import com.harrand.sketch.relation.notation.JointShapeBuilder.IJointShapeBldr;
import com.harrand.sketch.relation.notation.erNotation.IErNotation;
import com.harrand.sketch.relation.primitive.JointPrimitiveBldr;
import com.harrand.sketch.relation.primitive.JointPrimitiveCalc;
import com.harrand.util.LogUtil;
import java.awt.Color;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class JointGlyph
implements IJoint {
    private final JointPrimitiveCalc primitiveCalc;
    private final JointPrimitiveBldr jointPrimitiveBldr;
    private IErNotation erNotation;
    private Color strokeColor = Color.BLACK;
    private final String name;
    private List<EnhancedShape> eshapes = new ArrayList<EnhancedShape>();
    private final Cardinality cardinality;
    private Rectangle2D bounds_;
    private boolean selected_;
    private final LinkStrategy linkStrategy;
    private final boolean isSelfJoin;

    public JointGlyph(IErNotation erNotation, JointPrimitiveCalc jointPrimitiveCalc, Cardinality cardinality, Color strokeColor, String entityName, String linkName, LinkStrategy linkStrategy, boolean isSelfJoin) {
        this.setErNotation(erNotation);
        this.cardinality = cardinality;
        this.strokeColor = strokeColor;
        this.name = linkName + " " + entityName;
        this.primitiveCalc = jointPrimitiveCalc;
        this.jointPrimitiveBldr = new JointPrimitiveBldr(this.primitiveCalc, strokeColor);
        this.linkStrategy = linkStrategy;
        this.isSelfJoin = isSelfJoin;
        this.refresh();
    }

    public final void setErNotation(IErNotation erNotation) {
        this.erNotation = erNotation;
    }

    public final void refresh() {
        this.buildShapes();
        this.setBounds();
    }

    public Color getStrokeColor() {
        return this.strokeColor;
    }

    public void setStrokeColor(Color strokeColor) {
        this.strokeColor = strokeColor;
        this.jointPrimitiveBldr.setStrokeColor(this.strokeColor);
        this.refresh();
    }

    public IErNotation getErNotation() {
        return this.erNotation;
    }

    private void buildShapes() {
        IJointShapeBldr jointShapeBldr = this.erNotation.getJointShapeBldr();
        this.eshapes = jointShapeBldr.getJointShapes(this.jointPrimitiveBldr, this.cardinality, this.linkStrategy, this.isSelfJoin);
    }

    private void setBounds() {
        Rectangle2D maxRect = null;
        for (EnhancedShape eShape : this.eshapes) {
            Shape shape = eShape.getShape();
            if (maxRect == null) {
                maxRect = shape.getBounds2D();
                continue;
            }
            maxRect = GeometryHelper.getMaxBounds(shape.getBounds2D(), maxRect);
        }
        this.bounds_ = maxRect;
    }

    public double getHeight() {
        return this.primitiveCalc.getDiameter();
    }

    public double getLength() {
        return this.primitiveCalc.getBackBoneLength();
    }

    @Override
    public void setScaleFactor(double scaleFactor) {
        LogUtil.logErr("JointGlyph.setScaleFactor is not implemented.");
    }

    public Cardinality getCardiality() {
        return this.cardinality;
    }

    public double getAngle() {
        return this.primitiveCalc.getAngle();
    }

    @Override
    public boolean contains(Point2D p) {
        return this.getBounds2D().contains(p);
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    @Override
    public Rectangle2D getBounds2D() {
        return this.bounds_;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
    }

    public List<EnhancedShape> getEnhancedShapes() {
        return this.eshapes;
    }

    @Override
    public List<? extends IDrawable> getDrawables() {
        return this.getEnhancedShapes();
    }

    @Override
    public boolean isSelectable() {
        return false;
    }

    @Override
    public void move(Point p) {
        this.primitiveCalc.setStart(p);
        this.refresh();
    }

    @Override
    public void setAngle(double angle) {
        this.primitiveCalc.setAngle(angle);
        this.refresh();
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected_ = selected;
    }

    @Override
    public boolean getSelected() {
        return this.selected_;
    }

    @Override
    public Point2D getEndPoint() {
        return this.primitiveCalc.getEndPt();
    }

    @Override
    public Point2D getStartPoint() {
        Point2D startPt = this.primitiveCalc.getStart();
        return new Point2D.Double(startPt.getX(), startPt.getY());
    }
}

