/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.relation.edge.complimentary;

import com.harrand.sketch.relation.edge.Edge;
import com.harrand.util.LogUtil;
import java.awt.geom.Rectangle2D;

public final class TwoLineComplimentaryEdgeCalc {
    private boolean isBxFurther;
    private boolean isByFurther;

    public Edge getComplimentaryEdge(Edge edge, Rectangle2D rectA, Rectangle2D rectB) {
        this.calcFurther(rectA, rectB);
        switch (edge) {
            case EAST: {
                return this.getNorthOrSouthEdge();
            }
            case WEST: {
                return this.getNorthOrSouthEdge();
            }
            case NORTH: {
                return this.getEastOrWest();
            }
            case SOUTH: {
                return this.getEastOrWest();
            }
        }
        LogUtil.logErr(this.getClass().getSimpleName() + " could not match edge: " + (Object)((Object)edge));
        return null;
    }

    private void calcFurther(Rectangle2D rectA, Rectangle2D rectB) {
        this.isBxFurther = rectB.getCenterX() >= rectA.getCenterX();
        this.isByFurther = rectB.getCenterY() >= rectA.getCenterY();
    }

    private Edge getNorthOrSouthEdge() {
        if (this.isByFurther) {
            return Edge.NORTH;
        }
        return Edge.SOUTH;
    }

    private Edge getEastOrWest() {
        if (this.isBxFurther) {
            return Edge.WEST;
        }
        return Edge.EAST;
    }
}

