/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.relation.edge.adjacent;

import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.rect.LinkRect;
import com.harrand.util.LogUtil;

public final class IncursionAdjacentEdgeCalc {
    private LinkRect otherRect;
    private LinkRect incurredRect;

    public Edge getAdjacentEdge(Edge oldEdge, LinkRect incurredRect, LinkRect otherRect) {
        this.otherRect = otherRect;
        this.incurredRect = incurredRect;
        switch (oldEdge) {
            case NORTH: {
                return this.getNewEastOrWestEdge();
            }
            case SOUTH: {
                return this.getNewEastOrWestEdge();
            }
            case WEST: {
                return this.getNewNorthOrSouthEdge();
            }
            case EAST: {
                return this.getNewNorthOrSouthEdge();
            }
        }
        LogUtil.logErr(this.getClass().getSimpleName() + ", getAdjacentEdge switch fell through.");
        return null;
    }

    private Edge getNewNorthOrSouthEdge() {
        double incurredY;
        double otherY = this.otherRect.getCenterY();
        if (otherY < (incurredY = this.incurredRect.getCenterY())) {
            return Edge.NORTH;
        }
        return Edge.SOUTH;
    }

    private Edge getNewEastOrWestEdge() {
        double incurredX;
        double otherX = this.otherRect.getCenterX();
        if (otherX < (incurredX = this.incurredRect.getCenterX())) {
            return Edge.WEST;
        }
        return Edge.EAST;
    }
}

