/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.relation.edge;

import com.harrand.sketch.relation.edge.EdgeLimitResult;
import java.awt.geom.Rectangle2D;

public final class EdgeLimitCalc {
    private boolean withinTopLimit;
    private boolean withinBottomLimit;
    private boolean isOtherBoxLess;

    public EdgeLimitResult testXLimit(Rectangle2D box, double absX, Rectangle2D otherBox) {
        return this.doCalcs(absX, box.getMinX(), box.getMaxX(), box.getCenterX(), otherBox.getCenterX());
    }

    public EdgeLimitResult testYLimit(Rectangle2D box, double absY, Rectangle2D otherBox) {
        return this.doCalcs(absY, box.getMinY(), box.getMaxY(), box.getCenterY(), otherBox.getCenterY());
    }

    public EdgeLimitResult doCalcs(double coord, double minCoord, double maxCoord, double centerCoord, double otherCenterCoord) {
        boolean withInEdge = this.coordWithinEdge(coord, minCoord, maxCoord);
        if (withInEdge) {
            return EdgeLimitResult.WITHIN_EDGE_LIMITS;
        }
        this.isOtherBoxLess = centerCoord > otherCenterCoord;
        return this.getExceededResult();
    }

    private boolean coordWithinEdge(double coord, double minCoord, double maxCoord) {
        this.withinBottomLimit = coord >= minCoord;
        boolean bl = this.withinTopLimit = coord <= maxCoord;
        return this.withinBottomLimit && this.withinTopLimit;
    }

    private EdgeLimitResult getExceededResult() {
        if (!this.withinBottomLimit && this.isOtherBoxLess) {
            return EdgeLimitResult.NEEDS_EDGE_SWITCH_LOWER;
        }
        if (!this.withinTopLimit && !this.isOtherBoxLess) {
            return EdgeLimitResult.NEEDS_EDGE_SWITCH_HIGHER;
        }
        return EdgeLimitResult.EXCEEDS_BOUNDRY;
    }
}

