/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.listener.DataEditorVerifier;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.object.Zone;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class ZoneEditPanel
extends JPanel
implements DataEditor,
ITitled,
IObserver {
    private Diagram diagram_;
    private Zone zone_;
    private Point origin_ = new Point(0, 0);
    private JLabel lblName_ = new JLabel("Name");
    private JTextField txtName_ = new JTextField("");
    private JLabel lblText_ = new JLabel("Zone Text");
    private JTextArea txtText_ = new JTextArea();
    private JButton btnUpdate_ = GuiHelper.getUpdateBtn();
    private boolean syncOnEdit_ = false;
    private boolean startedUpdate_ = false;
    private InputVerifier verifier_;
    private ActionListener lisUpdate_;
    private boolean showBtnPanel_ = false;

    public ZoneEditPanel(Zone zone, Diagram diagram) {
        this.set(zone, diagram, false);
    }

    public ZoneEditPanel(Zone zone, Diagram diagram, boolean showBtnPanel) {
        this.set(zone, diagram, showBtnPanel);
    }

    public void setOrigin(Point pt) {
        this.origin_ = pt;
    }

    private void set(Zone zone, Diagram diagram, boolean showBtnPanel) {
        this.diagram_ = diagram;
        this.zone_ = zone;
        this.showBtnPanel_ = showBtnPanel;
        this.init();
    }

    private void init() {
        this.diagram_.addObserver(this);
        this.setupGui();
        this.loadData();
        this.buildListeners();
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
        this.syncOnEdit_ = sync;
        if (this.syncOnEdit_) {
            this.txtText_.setInputVerifier(this.verifier_);
            this.btnUpdate_.setVisible(true);
        } else {
            this.txtText_.setInputVerifier(null);
            this.btnUpdate_.setVisible(false);
        }
    }

    private void buildListeners() {
        this.verifier_ = new DataEditorVerifier(this);
        this.lisUpdate_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ZoneEditPanel.this.syncData();
                ZoneEditPanel.this.txtName_.requestFocus();
            }
        };
        this.addListeners();
    }

    private void addListeners() {
        this.btnUpdate_.addActionListener(this.lisUpdate_);
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.addListeners();
    }

    private void setCosmetics() {
        this.txtText_.setRows(5);
        this.txtText_.setFont(this.lblText_.getFont());
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(0, 4));
        this.add((Component)this.getTextPanel(), "North");
        if (this.showBtnPanel_) {
            this.add((Component)this.getButtonPanel(), "South");
        }
    }

    private JPanel getTextPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblName_, this.txtName_, gbc, panel, row++);
        return panel;
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createGlue());
        panel.add(this.btnUpdate_);
        return panel;
    }

    @Override
    public ITestResult validateData() {
        ITestResult result = this.syncData();
        if (!result.getPassed()) {
            this.loadData();
        }
        return result;
    }

    private void loadData() {
        if (this.zone_ != null) {
            this.txtName_.setText(this.zone_.getName());
            this.txtText_.setText(this.zone_.getText());
        } else {
            this.txtName_.setText("");
            this.txtText_.setText("");
        }
    }

    private ITestResult syncData() {
        DataEntryResult result = new DataEntryResult(true);
        String newNm = this.txtName_.getText();
        String newText = this.txtText_.getText();
        Rectangle newBounds = this.zone_ != null ? new Rectangle(this.zone_.getBounds()) : new Rectangle(this.origin_.x, this.origin_.y, 250, 250);
        Zone newZone = new Zone(newNm, newText, newBounds);
        if (this.zone_ != null) {
            newZone.setColor(this.zone_.getColor());
        }
        if (this.syncOnEdit_) {
            if (this.zone_ != null) {
                this.startedUpdate_ = true;
                if (!newZone.equals(this.zone_)) {
                    Zone oldZone = this.zone_;
                    this.zone_ = newZone;
                    UpdateInCollector.doUpdate(this.diagram_, oldZone, this.zone_, CommandChainMgr.getCmdChain(), null);
                }
            }
        } else {
            this.zone_ = newZone;
        }
        this.startedUpdate_ = false;
        return result;
    }

    public Zone getZone() {
        this.validateData();
        return this.zone_;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getZone();
    }

    @Override
    public Collector getCollector() {
        return this.diagram_;
    }

    @Override
    public String getTitle() {
        return StrHelper.getAddOrEditText(this.zone_) + "Zone";
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 375, 175);
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.ZONE;
    }

    @Override
    public void update(UpdateChain chain) {
        if (!this.startedUpdate_) {
            // empty if block
        }
    }
}

