/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.panel;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.listener.DataEditorVerifier;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.object.Note;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class NoteEditPanel
extends JPanel
implements DataEditor,
ITitled,
IObserver {
    private Diagram diagram_;
    private Note note_;
    private final JLabel lblText_ = new JLabel("Note Text");
    private final JTextArea txtText_ = new JTextArea();
    private final JButton btnUpdate_ = GuiHelper.getUpdateBtn();
    private boolean syncOnEdit_ = false;
    private boolean startedUpdate_ = false;
    private InputVerifier verifier_;
    private ActionListener lisUpdate_;
    public Point origin_ = new Point(0, 0);
    private boolean showBtnPanel_ = false;

    public NoteEditPanel(Note note, Diagram diagram) {
        this.set(note, diagram, false);
    }

    public NoteEditPanel(Note note, Diagram diagram, boolean showBtnPanel) {
        this.set(note, diagram, showBtnPanel);
    }

    private void set(Note note, Diagram diagram, boolean showBtnPanel) {
        this.diagram_ = diagram;
        this.note_ = note;
        this.showBtnPanel_ = showBtnPanel;
        this.init();
    }

    public void setOrigin(Point pt) {
        this.origin_ = pt;
    }

    private void init() {
        this.diagram_.addObserver(this);
        this.setupGui();
        this.loadData();
        this.buildListeners();
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
        this.syncOnEdit_ = sync;
        if (this.syncOnEdit_) {
            this.txtText_.setInputVerifier(this.verifier_);
            this.btnUpdate_.setVisible(true);
        } else {
            this.txtText_.setInputVerifier(null);
            this.btnUpdate_.setVisible(false);
        }
    }

    private void buildListeners() {
        this.verifier_ = new DataEditorVerifier(this);
        this.lisUpdate_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NoteEditPanel.this.syncData();
                NoteEditPanel.this.txtText_.requestFocus();
            }
        };
        this.addListeners();
    }

    private void addListeners() {
        this.btnUpdate_.addActionListener(this.lisUpdate_);
    }

    private void setCosmetics() {
        this.txtText_.setRows(5);
        this.txtText_.setFont(this.lblText_.getFont());
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout(0, 4));
        this.add((Component)this.getTextPanel(), "North");
        if (this.showBtnPanel_) {
            this.add((Component)this.getButtonPanel(), "South");
            GuiHelper.addBodyPanelBorder(this);
        }
    }

    private JPanel getTextPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.buildGridBagConstraints(gbc, 0, row, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 18;
        panel.add((Component)this.lblText_, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 1, row++, 1, 1, 90.0, 0.0);
        gbc.fill = 1;
        gbc.anchor = 18;
        panel.add((Component)new JScrollPane(this.txtText_), gbc);
        return panel;
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createGlue());
        panel.add(this.btnUpdate_);
        return panel;
    }

    @Override
    public ITestResult validateData() {
        ITestResult result = this.syncData();
        if (!result.getPassed()) {
            this.loadData();
        }
        return result;
    }

    private void loadData() {
        if (this.note_ != null) {
            this.txtText_.setText(this.note_.getText());
        } else {
            this.txtText_.setText("");
        }
    }

    private ITestResult syncData() {
        DataEntryResult result = new DataEntryResult(true);
        String newText = this.txtText_.getText();
        if (this.note_ != null) {
            this.startedUpdate_ = true;
            String oldText = this.note_.getText();
            if (!oldText.equals(newText)) {
                Note newNote = this.note_.dup(newText);
                if (this.syncOnEdit_) {
                    UpdateInCollector.doUpdate(this.diagram_, this.note_, newNote, CommandChainMgr.getCmdChain(), null);
                }
                this.note_ = newNote;
            }
        } else {
            this.note_ = new Note(newText, this.origin_);
        }
        this.startedUpdate_ = false;
        return result;
    }

    public Note getNote() {
        this.validateData();
        return this.note_;
    }

    @Override
    public Identifiable getDataObject() {
        return this.getNote();
    }

    @Override
    public Collector getCollector() {
        return this.diagram_;
    }

    @Override
    public String getTitle() {
        return StrHelper.getAddOrEditText(this.note_) + Note.getClassName();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 375, 225);
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.NOTE;
    }

    @Override
    public void update(UpdateChain chain) {
        if (!this.startedUpdate_) {
            // empty if block
        }
    }
}

