/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.panel;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.element.Cardinality;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.dbwrench.diagram.relation.notation.erNotation.DbwErNotationFactory;
import com.harrand.sketch.j2d.EnhancedShape;
import com.harrand.sketch.j2d.draw.IDrawable;
import com.harrand.sketch.linkStrategies.CenterDirect;
import com.harrand.sketch.relation.glyph.JointGlyph;
import com.harrand.sketch.relation.joint.JointDimensionCalc;
import com.harrand.sketch.relation.notation.erNotation.IErNotation;
import com.harrand.sketch.relation.primitive.JointPrimitiveCalc;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CardinalityPanel
extends JPanel
implements IObservable {
    private List cardinalities_;
    private BasicObservable observable_;
    private JLabel lblPrompt_;
    private JComboBox cboCardinality_;
    private ActionListener lisCardi_;

    public CardinalityPanel(String prompt, List cardinalities) {
        this.lblPrompt_ = new JLabel(prompt);
        this.cardinalities_ = cardinalities;
        this.observable_ = new BasicObservable();
        this.buildControls();
        this.setupGui();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawImage(g);
    }

    public void setSelectedCardinality(Cardinality cardinality) {
        this.cboCardinality_.removeActionListener(this.lisCardi_);
        this.cboCardinality_.setSelectedItem(cardinality);
        this.cboCardinality_.addActionListener(this.lisCardi_);
    }

    public Cardinality getSelectedCardinality() {
        return (Cardinality)this.cboCardinality_.getSelectedItem();
    }

    private IErNotation getErNotation() {
        return DbwErNotationFactory.getInstance().getOptionMgrNotation();
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void buildControls() {
        Vector v = new Vector(this.cardinalities_);
        this.cboCardinality_ = new JComboBox(v);
    }

    private void layoutComponents() {
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.lblPrompt_);
        this.add(Box.createHorizontalStrut(8));
        this.add(this.cboCardinality_);
        this.add(Box.createHorizontalStrut(4));
    }

    private void setCosmetics() {
        this.cboCardinality_.setPrototypeDisplayValue("XXXXXXXX");
        Dimension commonSize = this.cboCardinality_.getMinimumSize();
        this.cboCardinality_.setMaximumSize(commonSize);
    }

    private void setNames() {
        this.cboCardinality_.setName("cboCardinality");
    }

    private void addListeners() {
        this.lisCardi_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardinalityPanel.this.refreshCardinality();
            }
        };
        this.cboCardinality_.addActionListener(this.lisCardi_);
    }

    private void refreshCardinality() {
        this.drawImage(this.getGraphics());
        this.notifyObservers(new UpdateChain(this.getSelectedCardinality()));
    }

    private void drawImage(Graphics g) {
        double startX = this.cboCardinality_.getLocation().getX() + (double)this.cboCardinality_.getWidth() + 8.0;
        double startY = this.getHeight() / 2;
        Point2D.Double start = new Point2D.Double(startX, startY);
        IErNotation erNotation = this.getErNotation();
        JointDimensionCalc jntDimCalc = new JointDimensionCalc(1.0);
        JointPrimitiveCalc jntPrimitiveCalc = new JointPrimitiveCalc(start, 0.0, jntDimCalc);
        JointGlyph glyph = new JointGlyph(erNotation, jntPrimitiveCalc, this.getSelectedCardinality(), Colors.getBlueKeyword(), "test", "link", new CenterDirect(), false);
        List<? extends IDrawable> shapes = glyph.getDrawables();
        if (g != null) {
            Graphics2D gfx = (Graphics2D)g;
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Zoom zoom = new Zoom(1.0);
            for (EnhancedShape enhancedShape : shapes) {
                enhancedShape.draw(gfx, zoom);
            }
        }
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

