/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.object;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.display.color.DefaultColorCtrl;
import com.harrand.coreclasses.element.IQualifiedNm;
import com.harrand.coreclasses.interfaces.IConfirmRemove;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.sketch.core.helper.RectangleHelper;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;

public class Zone
implements Identifiable,
IObservable,
IConfirmRemove,
IQualifiedNm {
    private String nm_;
    private String text_;
    private Rectangle rect_;
    private BasicObservable observable_ = new BasicObservable();
    private Color color_ = DEFAULT_COLOR;
    public static final String CLZ = "Zone";
    public static final String CLZ_DISPLAY_PL = "Zones";
    public static final Color DEFAULT_COLOR = Colors.getBeige();

    public Zone(String nm, String text, Rectangle rect) {
        this.initNm(nm);
        this.text_ = text;
        this.rect_ = rect;
        this.initColor();
    }

    public void setText(String text) {
        this.text_ = text;
        this.notifyObservers(null);
    }

    public void setOrigin(Point origin) {
        this.rect_.setLocation(origin);
    }

    public void setRect(Rectangle rect) {
        boolean isSameSize = RectangleHelper.isRectSameSize(this.rect_, rect);
        this.rect_ = rect;
        if (!isSameSize) {
            this.notifyObservers(null);
        }
    }

    public void setColor(Color color) {
        this.color_ = color;
        DefaultColorCtrl.getInstance().putDefaultColor(this.getClass(), this.color_);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof Zone)) {
            return false;
        }
        Zone other = (Zone)o;
        if (!other.getName().equals(this.getName())) {
            return false;
        }
        return other.getText().equals(this.getText());
    }

    public String getText() {
        return this.text_;
    }

    public Color getColor() {
        return this.color_;
    }

    public Rectangle getBounds() {
        return this.rect_;
    }

    public static String getClassName() {
        return CLZ;
    }

    @Override
    public String getMapName() {
        return CLZ;
    }

    @Override
    public String getDisplayClzNm() {
        return CLZ;
    }

    @Override
    public String getDisplayClzPlural() {
        return CLZ_DISPLAY_PL;
    }

    @Override
    public String getName() {
        return this.nm_;
    }

    @Override
    public boolean getConfirmRemove() {
        return false;
    }

    @Override
    public String getQN() {
        return "Zone." + this.getName();
    }

    @Override
    public final void setName(String nm) {
        this.initNm(nm);
        this.notifyObservers(new UpdateChain(this));
    }

    private final void initNm(String nm) {
        this.nm_ = nm;
    }

    private void initColor() {
        this.setColor(DefaultColorCtrl.getInstance().getDefaultColorSafe(this.getClass(), DEFAULT_COLOR));
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

