/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.rollover.switch_edge_ctrl;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.right_angle.transitioner.OneToTwoLineTransitioner;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.edge.EdgeLimitResult;
import com.harrand.sketch.relation.edge.IEdgeTrackable;
import com.harrand.sketch.relation.edge.adjacent.EdgeLimitAdjacentEdgeCalc;
import com.harrand.sketch.relation.rect.LinkRect;

public final class OneLineSwitchEdgeCtrl {
    private final EdgeLimitAdjacentEdgeCalc adjacentEdgeCalc = new EdgeLimitAdjacentEdgeCalc();
    private LinkRect transitionedRect;

    public void switchEdge(BoxLink boxLink, LinkRect transitionedBox, EdgeLimitResult edgeLimitResult) {
        this.transitionedRect = transitionedBox;
        IEdgeTrackable edgeTrackable = (IEdgeTrackable)((Object)boxLink);
        Edge oldEdge = this.getEdge(edgeTrackable);
        Edge newEdge = this.adjacentEdgeCalc.getAdjacentEdge(oldEdge, edgeLimitResult);
        this.setEdge(edgeTrackable, newEdge);
        OneToTwoLineTransitioner oneToTwoLineTransitioner = new OneToTwoLineTransitioner();
        oneToTwoLineTransitioner.transitionLink(boxLink, transitionedBox, oldEdge, newEdge);
    }

    private Edge getEdge(IEdgeTrackable edgeTrackable) {
        if (this.transitionedRect.isParent()) {
            return edgeTrackable.getParentEdge();
        }
        if (this.transitionedRect.isChild()) {
            return edgeTrackable.getChildEdge();
        }
        return null;
    }

    private void setEdge(IEdgeTrackable edgeTrackable, Edge newEdge) {
        if (this.transitionedRect.isParent()) {
            edgeTrackable.setParentEdge(newEdge);
        }
        if (this.transitionedRect.isChild()) {
            edgeTrackable.setChildEdge(newEdge);
        }
    }
}

