/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.transitioner;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.arc.LineBasedArcBuilder;
import com.harrand.sketch.linkStrategies.right_angle.calc.intersect.TransitionToThreeLinesIntersectCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.common.ThreeLinePositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.LinkLineExtractor;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.ThreeLineUserLinkPositioner;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.line.move.LineMoveCtrl;
import com.harrand.sketch.relation.rect.LinkRect;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

public final class TwoToThreeLineTransitioner {
    private PositionableLine parentLine;
    private PositionableLine middleLine;
    private PositionableLine childLine;
    private BoxLink boxLink;
    private Arc2D childArc;
    private Arc2D parentArc;
    private ArrayList<Shape> shapes;

    public void transitionLink(BoxLink boxLink, LinkRect transitionedBox, LinkRect otherBox, Edge oldEdge, Edge newEdge, Edge otherEdge) {
        this.boxLink = boxLink;
        this.extractLines();
        this.positionLines(transitionedBox, oldEdge, newEdge);
        this.buildArcs();
        this.buildShapes();
        boxLink.setShapes(this.shapes);
        ThreeLineUserLinkPositioner linkPositioner = new ThreeLineUserLinkPositioner();
        boxLink.setLinkPositioner(linkPositioner);
        LineMoveCtrl.getInstance().setLine(this.middleLine, this.boxLink);
    }

    private void positionLines(LinkRect transitionedBox, Edge oldEdge, Edge newEdge) {
        TransitionToThreeLinesIntersectCalc transitionIntersectCalc = new TransitionToThreeLinesIntersectCalc();
        Point2D[] parentAndChildIntersect = transitionIntersectCalc.calcParentAndChildIntersects(this.boxLink, transitionedBox, oldEdge, newEdge);
        ThreeLinePositioner linePositioner = new ThreeLinePositioner();
        linePositioner.positionLines(this.boxLink, parentAndChildIntersect);
        this.parentLine = linePositioner.getParentLine();
        this.childLine = linePositioner.getChildLine();
        this.middleLine = linePositioner.getMiddleLine();
    }

    private void extractLines() {
        LinkLineExtractor extractor = new LinkLineExtractor();
        List<PositionableLine> lines = extractor.getPositionableLines(this.boxLink);
        this.parentLine = lines.get(0);
        this.childLine = lines.get(1);
    }

    private void buildArcs() {
        this.childArc = new LineBasedArcBuilder().getArc(this.childLine, this.middleLine);
        this.parentArc = new LineBasedArcBuilder().getArc(this.parentLine, this.middleLine);
    }

    private void buildShapes() {
        this.shapes = new ArrayList();
        this.shapes.add(this.parentLine);
        this.shapes.add(this.childLine);
        this.shapes.add(this.middleLine);
        if (this.parentArc != null) {
            this.shapes.add(this.parentArc);
        }
        if (this.childArc != null) {
            this.shapes.add(this.childArc);
        }
    }
}

