/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.transitioner;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.right_angle.calc.intersect.EdgeTransitionIntersectCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.BoxPointCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.LinkLineExtractor;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.OneLineUserLinkPositioner;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.edge.IEdgeTrackable;
import com.harrand.sketch.relation.line.LineRole;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.line.move.LineMoveCtrl;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public final class TwoToOneLineTransitioner {
    private final LinkLineExtractor lineExtractor = new LinkLineExtractor();
    private final EdgeTransitionIntersectCalc commonIntersectCalc = new EdgeTransitionIntersectCalc();
    private final BoxPointCalc boxPointCalc = new BoxPointCalc();
    private PositionableLine parentLine;
    private ArrayList<Shape> shapes;
    private BoxLink boxLink;
    private IEdgeTrackable edgeTrackable;
    private Rectangle2D parentBox;
    private Rectangle2D childBox;
    private Edge oldEdge;
    private Edge newEdge;
    private Rectangle2D transitionedBox;

    public void transitionLink(BoxLink boxLink, Rectangle2D transitionedBox, Edge oldEdge, Edge newEdge, boolean wasAnIncursion) {
        this.boxLink = boxLink;
        this.edgeTrackable = (IEdgeTrackable)((Object)boxLink);
        this.parentBox = boxLink.getBox("Parent");
        this.childBox = boxLink.getBox("Child");
        this.oldEdge = oldEdge;
        this.newEdge = newEdge;
        this.transitionedBox = transitionedBox;
        this.positionLines();
        this.buildShapes();
        boxLink.setShapes(this.shapes);
        OneLineUserLinkPositioner oneLineUserLinkPositioner = new OneLineUserLinkPositioner();
        boxLink.setLinkPositioner(oneLineUserLinkPositioner);
        if (wasAnIncursion) {
            LineMoveCtrl.getInstance().setLine(this.parentLine, boxLink);
        } else {
            LineMoveCtrl.getInstance().setLine(null, null);
        }
    }

    private void positionLines() {
        Point2D commonPt = this.getCommonPoint();
        Point2D newP1 = this.boxPointCalc.getLineEndPoint(this.parentBox, this.getParentEdge(), commonPt);
        Point2D newP2 = this.boxPointCalc.getLineEndPoint(this.childBox, this.getChildEdge(), commonPt);
        List<PositionableLine> lines = this.lineExtractor.getPositionableLines(this.boxLink);
        this.parentLine = lines.get(0);
        this.parentLine.setLine(newP1, newP2);
        this.parentLine.updateAbs(this.boxLink);
        this.parentLine.setLineRole(LineRole.SINGLE_LINE);
    }

    private void buildShapes() {
        this.shapes = new ArrayList();
        this.shapes.add(this.parentLine);
    }

    private Edge getChildEdge() {
        return this.edgeTrackable.getChildEdge();
    }

    private Edge getParentEdge() {
        return this.edgeTrackable.getParentEdge();
    }

    private Point2D getCommonPoint() {
        Point2D commonPt = this.commonIntersectCalc.getIntersect(this.transitionedBox, this.oldEdge, this.newEdge);
        return commonPt;
    }
}

