/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.transitioner;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.arc.LineBasedArcBuilder;
import com.harrand.sketch.linkStrategies.right_angle.positioner.common.TwoLinePositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.LinkLineExtractor;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.TwoLineRelativeIntersectCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.TwoLineUserLinkPositioner;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.line.LineRole;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.line.move.LineMoveCtrl;
import com.harrand.sketch.relation.rect.LinkRect;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public final class ThreeToTwoLineTransitioner {
    private static final int OFFSET_FROM_EDGE_TRANSITION = 5;
    private final TwoLineRelativeIntersectCalc intersectCalc = new TwoLineRelativeIntersectCalc();
    private final TwoLinePositioner twoLinePositioner = new TwoLinePositioner();
    private PositionableLine parentLine;
    private PositionableLine childLine;
    private Edge oldEdge;
    private ArrayList<Shape> shapes;
    private Arc2D arc;
    private LinkRect transitionedBox;

    public void transitionLink(BoxLink boxLink, LinkRect transitionedBox, Edge oldEdge, Edge newEdge, boolean wasAnIncursion) {
        this.transitionedBox = transitionedBox;
        this.oldEdge = oldEdge;
        this.positionLines(boxLink);
        this.positionArc();
        this.buildShapes();
        boxLink.setShapes(this.shapes);
        TwoLineUserLinkPositioner twoLineUserLinkPositioner = new TwoLineUserLinkPositioner();
        boxLink.setLinkPositioner(twoLineUserLinkPositioner);
        if (wasAnIncursion) {
            PositionableLine newMoveLine = this.isTransitionedBoxParent() ? this.parentLine : this.childLine;
            LineMoveCtrl.getInstance().setLine(newMoveLine, boxLink);
        } else {
            LineMoveCtrl.getInstance().setLine(null, null);
        }
    }

    private boolean isTransitionedBoxParent() {
        return this.transitionedBox.getName().equalsIgnoreCase("Parent");
    }

    private void positionLines(BoxLink boxLink) {
        LinkLineExtractor lineExtractor = new LinkLineExtractor();
        this.parentLine = lineExtractor.getParentLine(boxLink);
        this.childLine = lineExtractor.getChildLine(boxLink);
        this.setLineRelValue(boxLink);
        Point2D intersect = this.intersectCalc.calcIntersect(boxLink);
        this.twoLinePositioner.positionLines(boxLink, intersect);
        this.parentLine = this.twoLinePositioner.getParentLine();
        this.childLine = this.twoLinePositioner.getChildLine();
        this.parentLine.setLineRole(LineRole.PARENT_LINE);
    }

    private void positionArc() {
        this.arc = new LineBasedArcBuilder().getArc(this.childLine, this.parentLine);
    }

    private void buildShapes() {
        this.shapes = new ArrayList();
        this.shapes.add(this.parentLine);
        this.shapes.add(this.childLine);
        if (this.arc != null) {
            this.shapes.add(this.arc);
        }
    }

    private void setLineRelValue(BoxLink link) {
        double newX;
        double newY;
        if (Edge.SOUTH.equals((Object)this.oldEdge)) {
            newY = this.transitionedBox.getY() + this.transitionedBox.getHeight() - 5.0;
            this.setLineAbsY(link, newY);
        }
        if (Edge.NORTH.equals((Object)this.oldEdge)) {
            newY = this.transitionedBox.getY() + 5.0;
            this.setLineAbsY(link, newY);
        }
        if (Edge.EAST.equals((Object)this.oldEdge)) {
            newX = this.transitionedBox.getX() + this.transitionedBox.getWidth() - 5.0;
            this.setLineAbsX(link, newX);
        }
        if (Edge.WEST.equals((Object)this.oldEdge)) {
            newX = this.transitionedBox.getX() + 5.0;
            this.setLineAbsX(link, newX);
        }
    }

    private void setLineAbsX(BoxLink link, double newX) {
        if (this.isTransitionedBoxParent()) {
            this.parentLine.setAbsX(link, newX);
        } else {
            this.childLine.setAbsX(link, newX);
        }
    }

    private void setLineAbsY(BoxLink link, double newY) {
        if (this.isTransitionedBoxParent()) {
            this.parentLine.setAbsY(link, newY);
        } else {
            this.childLine.setAbsY(link, newY);
        }
    }
}

