/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.user;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.arc.LineBasedArcBuilder;
import com.harrand.sketch.linkStrategies.positioner.ILinkPositioner;
import com.harrand.sketch.linkStrategies.right_angle.calc.JointPositioner;
import com.harrand.sketch.linkStrategies.right_angle.calc.NamePositionCoordSetter;
import com.harrand.sketch.linkStrategies.right_angle.positioner.common.TwoLinePositioner;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.TwoLineRelativeIntersectCalc;
import com.harrand.sketch.relation.edge.IEdgeTrackable;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.line.move.BoxedLineMoveChecker;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public final class TwoLineUserLinkPositioner
implements ILinkPositioner {
    private final TwoLineRelativeIntersectCalc intersectCalc = new TwoLineRelativeIntersectCalc();
    private final TwoLinePositioner twoLinePositioner = new TwoLinePositioner();
    private final JointPositioner jointPositioner = new JointPositioner();
    private final NamePositionCoordSetter namePositionCoordSetter = new NamePositionCoordSetter();
    private BoxLink boxLink;
    private PositionableLine childLine;
    private PositionableLine parentLine;
    private Arc2D arc;
    private boolean isLinkTransitioned;
    private final BoxedLineMoveChecker lineMoveChecker = new BoxedLineMoveChecker();
    private Point2D intersect;

    @Override
    public void updateShapePositions(BoxLink boxLink) {
        this.boxLink = boxLink;
        this.positionLines();
        if (!this.isLinkTransitioned) {
            this.positionArc();
            this.positionJoints();
            this.updateShapes();
        }
    }

    private void updateShapes() {
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        shapes.add(this.parentLine);
        shapes.add(this.childLine);
        if (this.arc != null) {
            shapes.add(this.arc);
        }
        this.boxLink.setShapes(shapes);
        this.namePositionCoordSetter.setNmPos(this.boxLink, this.parentLine);
    }

    private void positionLines() {
        this.intersect = this.intersectCalc.calcIntersect(this.boxLink);
        this.twoLinePositioner.positionLines(this.boxLink, this.intersect);
        this.parentLine = this.twoLinePositioner.getParentLine();
        this.childLine = this.twoLinePositioner.getChildLine();
        this.isLinkTransitioned = this.lineMoveChecker.isLinkTransitioned(this.boxLink, this.parentLine, this.parentLine.getP1());
        if (!this.isLinkTransitioned) {
            this.isLinkTransitioned = this.lineMoveChecker.isLinkTransitioned(this.boxLink, this.childLine, this.childLine.getP1());
        }
    }

    private void positionArc() {
        this.arc = new LineBasedArcBuilder().getArc(this.childLine, this.parentLine);
    }

    private void positionJoints() {
        Point2D jointPoint = this.twoLinePositioner.getChildJointEndPoint();
        this.jointPositioner.positionJoint(this.boxLink, jointPoint, ((IEdgeTrackable)((Object)this.boxLink)).getChildEdge(), "ChildJoint");
        jointPoint = this.twoLinePositioner.getParentJointEndPoint();
        this.jointPositioner.positionJoint(this.boxLink, jointPoint, ((IEdgeTrackable)((Object)this.boxLink)).getParentEdge(), "ParentJoint");
    }
}

