/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.user;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.positioner.ILinkPositioner;
import com.harrand.sketch.linkStrategies.right_angle.calc.JointPositioner;
import com.harrand.sketch.linkStrategies.right_angle.calc.NamePositionCoordSetter;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.BoxPointCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.user.LinkLineExtractor;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.edge.IEdgeTrackable;
import com.harrand.sketch.relation.line.PositionableLine;
import com.harrand.sketch.relation.line.move.BoxedLineMoveChecker;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public final class OneLineUserLinkPositioner
implements ILinkPositioner {
    private final BoxPointCalc boxPointCalc = new BoxPointCalc();
    private final LinkLineExtractor lineExtractor = new LinkLineExtractor();
    private Rectangle2D childBox;
    private Rectangle2D parentBox;
    private PositionableLine line;
    private final JointPositioner jointPositioner = new JointPositioner();
    private BoxLink boxLink;
    private final NamePositionCoordSetter namePositionCoordSetter = new NamePositionCoordSetter();
    private IEdgeTrackable edgeTrackable;
    private boolean isLinkTransitioned;
    private final BoxedLineMoveChecker lineMoveChecker = new BoxedLineMoveChecker();
    private Point2D commonPt;

    @Override
    public void updateShapePositions(BoxLink boxLink) {
        this.initFields(boxLink);
        this.positionLines();
        if (!this.isLinkTransitioned) {
            this.positionJoints();
            this.updateShapes();
        }
    }

    private Edge getChildEdge() {
        return this.edgeTrackable.getChildEdge();
    }

    private Edge getParentEdge() {
        return this.edgeTrackable.getParentEdge();
    }

    private void initFields(BoxLink boxLink) {
        this.boxLink = boxLink;
        this.edgeTrackable = (IEdgeTrackable)((Object)boxLink);
        this.parentBox = boxLink.getBox(boxLink.getParentBoxName());
        this.childBox = boxLink.getBox(boxLink.getChildBoxName());
        List<PositionableLine> positionableLines = this.lineExtractor.getPositionableLines(boxLink);
        if (!positionableLines.isEmpty()) {
            this.line = positionableLines.get(0);
        }
    }

    private void positionLines() {
        this.commonPt = this.getCommonPoint();
        Point2D newP1 = this.boxPointCalc.getLineEndPoint(this.parentBox, this.getParentEdge(), this.commonPt);
        Point2D newP2 = this.boxPointCalc.getLineEndPoint(this.childBox, this.getChildEdge(), this.commonPt);
        this.isLinkTransitioned = this.lineMoveChecker.isLinkTransitioned(this.boxLink, this.line, newP1);
        if (!this.isLinkTransitioned) {
            this.line.setLine(newP1, newP2);
        }
    }

    private void positionJoints() {
        Point2D jointPoint = this.boxPointCalc.getJointEndPoint(this.childBox, this.getChildEdge(), this.commonPt);
        this.jointPositioner.positionJoint(this.boxLink, jointPoint, this.getChildEdge(), "ChildJoint");
        jointPoint = this.boxPointCalc.getJointEndPoint(this.parentBox, this.getParentEdge(), this.commonPt);
        this.jointPositioner.positionJoint(this.boxLink, jointPoint, this.getParentEdge(), "ParentJoint");
    }

    private void updateShapes() {
        ArrayList<PositionableLine> shapes = new ArrayList<PositionableLine>();
        shapes.add(this.line);
        this.boxLink.setShapes(shapes);
        this.namePositionCoordSetter.setNmPos(this.boxLink, this.line);
    }

    private Point2D getCommonPoint() {
        if (this.line.isVerticalLine()) {
            double y = Edge.NORTH.equals((Object)this.getParentEdge()) ? this.parentBox.getMinY() : this.parentBox.getMaxY();
            return new Point2D.Double(this.getCalculatedX(), y);
        }
        double x = Edge.WEST.equals((Object)this.getParentEdge()) ? this.parentBox.getMinX() : this.parentBox.getMaxX();
        return new Point2D.Double(x, this.getCalculatedY());
    }

    private double getCalculatedY() {
        return this.parentBox.getMinY() + this.line.getRelY();
    }

    private double getCalculatedX() {
        return this.parentBox.getMinX() + this.line.getRelX();
    }
}

