/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket;

import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkedBox;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.EdgeSockets;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.JointSocket;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.util.LogUtil;
import java.awt.geom.Rectangle2D;
import java.util.Map;

public final class EdgeSocketPositioner {
    private LinkedBox linkedBox;

    public void setOffsets(LinkedBox linkedBox, Map<Edge, EdgeSockets> edgeSocketsMap) {
        this.linkedBox = linkedBox;
        for (Edge edge : edgeSocketsMap.keySet()) {
            EdgeSockets edgeSockets = edgeSocketsMap.get((Object)edge);
            this.setOffsetsByEdge(edgeSockets);
        }
    }

    private void setOffsetsByEdge(EdgeSockets edgeSockets) {
        int spacing = this.getSpacing(edgeSockets.getEdge(), edgeSockets.getOrderedSockets().size());
        int position = 1;
        for (JointSocket jointSocket : edgeSockets.getOrderedSockets()) {
            jointSocket.setLinearOffset(position * spacing);
            ++position;
        }
    }

    private int getSpacing(Edge edge, int socketCount) {
        Rectangle2D rect = this.linkedBox.getDiagramBox().getRect();
        int divisor = socketCount + 1;
        switch (edge) {
            case NORTH: {
                return this.doDivision(rect.getWidth(), divisor);
            }
            case EAST: {
                return this.doDivision(rect.getHeight(), divisor);
            }
            case SOUTH: {
                return this.doDivision(rect.getWidth(), divisor);
            }
            case WEST: {
                return this.doDivision(rect.getHeight(), divisor);
            }
        }
        LogUtil.logErr(this.getClass().getSimpleName() + " could not match edge: " + (Object)((Object)edge));
        return -1;
    }

    private int doDivision(double sideLength, int divisor) {
        return (int)sideLength / divisor;
    }
}

