/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.Bearing;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkBoxPair;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkedBox;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.BearingSockets;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.ESocketEnd;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.EdgeSockets;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.EdgeSocketsDistributor;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.JointSocket;
import com.harrand.sketch.relation.edge.Edge;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class EdgeSocketCalc {
    private Map<Bearing, BearingSockets> bearingSocketsMap = new HashMap<Bearing, BearingSockets>();
    private Map<String, LinkBoxPair> linkName_LinkBoxPairsMap;
    private List<JointSocket> rankedSockets;
    private LinkedBox linkedBox;

    public Map<Edge, EdgeSockets> getEdgeSockets(LinkedBox linkedBox, List<LinkBoxPair> linkBoxPairs) {
        this.linkedBox = linkedBox;
        this.buildLinkBoxPairsMap(linkBoxPairs);
        this.initBearingSocketMap();
        this.buildSocketsForBox();
        this.updateRankedSockets(linkedBox);
        Map<Edge, EdgeSockets> edgeSockets = this.getEdgeSocketsMap();
        return edgeSockets;
    }

    private void updateRankedSockets(LinkedBox linkedBox) {
        this.rankedSockets = new ArrayList<JointSocket>();
        for (BearingSockets bearingSockets : this.bearingSocketsMap.values()) {
            this.rankedSockets.addAll(bearingSockets.getRankedSockets(linkedBox));
        }
    }

    private void buildSocketsForBox() {
        for (BoxLink boxLink : this.linkedBox.getBoxLinks()) {
            LinkBoxPair linkBoxPair = this.linkName_LinkBoxPairsMap.get(boxLink.getName());
            boolean isParentJoint = this.isParentJoint(linkBoxPair);
            JointSocket socket = this.initSocket(linkBoxPair, isParentJoint);
            this.addToBearingSockets(socket, linkBoxPair, isParentJoint);
        }
    }

    private JointSocket initSocket(LinkBoxPair linkBoxPair, boolean isParentJoint) {
        JointSocket socket = null;
        if (isParentJoint) {
            if (linkBoxPair.getParentSocket() == null) {
                socket = new JointSocket(linkBoxPair, ESocketEnd.PARENT);
                linkBoxPair.setParentSocket(socket);
            } else {
                socket = linkBoxPair.getParentSocket();
            }
            if (linkBoxPair.getChildSocket() == null) {
                JointSocket complimentarySocket = new JointSocket(linkBoxPair, ESocketEnd.CHILD);
                linkBoxPair.setChildSocket(complimentarySocket);
            }
        } else {
            if (linkBoxPair.getChildSocket() == null) {
                socket = new JointSocket(linkBoxPair, ESocketEnd.CHILD);
                linkBoxPair.setChildSocket(socket);
            } else {
                socket = linkBoxPair.getChildSocket();
            }
            if (linkBoxPair.getParentSocket() == null) {
                JointSocket complimentarySocket = new JointSocket(linkBoxPair, ESocketEnd.PARENT);
                linkBoxPair.setParentSocket(complimentarySocket);
            }
        }
        return socket;
    }

    private void addToBearingSockets(JointSocket socket, LinkBoxPair linkBoxpair, boolean isParentJoint) {
        Bearing bearing = isParentJoint ? linkBoxpair.getParentBearing() : linkBoxpair.getChildBearing();
        BearingSockets bearingSockets = this.bearingSocketsMap.get((Object)bearing);
        bearingSockets.addSocket(socket);
    }

    private Map<Edge, EdgeSockets> getEdgeSocketsMap() {
        return new EdgeSocketsDistributor().buildEdgeSockets(this.rankedSockets);
    }

    private boolean isParentJoint(LinkBoxPair linkBoxPair) {
        String boxDotNote = this.linkedBox.getDotNote();
        String parentBoxDoteNote = linkBoxPair.getParentBox().getDotNote();
        return parentBoxDoteNote.equals(boxDotNote);
    }

    private void initBearingSocketMap() {
        this.putBearingSocket(Bearing.NORTH);
        this.putBearingSocket(Bearing.NORTH_EAST);
        this.putBearingSocket(Bearing.EAST);
        this.putBearingSocket(Bearing.SOUTH_EAST);
        this.putBearingSocket(Bearing.SOUTH);
        this.putBearingSocket(Bearing.SOUTH_WEST);
        this.putBearingSocket(Bearing.WEST);
        this.putBearingSocket(Bearing.NORTH_WEST);
    }

    private void putBearingSocket(Bearing bearing) {
        this.bearingSocketsMap.put(bearing, new BearingSockets(bearing));
    }

    private void buildLinkBoxPairsMap(List<LinkBoxPair> linkBoxPairs) {
        this.linkName_LinkBoxPairsMap = new HashMap<String, LinkBoxPair>();
        for (LinkBoxPair linkBoxPair : linkBoxPairs) {
            String linkName = linkBoxPair.getBoxLink().getName();
            this.linkName_LinkBoxPairsMap.put(linkName, linkBoxPair);
        }
    }
}

