/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box;

import com.harrand.sketch.core.BoxLink;
import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.core.box.DiagramBox;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.Bearing;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.ESocketEnd;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.JointSocket;
import com.harrand.util.LogUtil;

public final class LinkBoxPair {
    private final BoxLink boxLink;
    private DiagramBox childBox;
    private DiagramBox parentBox;
    private Bearing parentBearing;
    private Bearing childBearing;
    private double middleLineOffset;
    private Integer linkLineCount;
    private JointSocket parentSocket;
    private JointSocket childSocket;

    public LinkBoxPair(BoxLink link) {
        this.boxLink = link;
    }

    public int getBoxDistance() {
        int distance = GeometryHelper.getDistance(this.childBox.getRect(), this.parentBox.getRect());
        return distance;
    }

    public DiagramBox getComplimentaryDiagramBox(JointSocket socket) {
        ESocketEnd socketEnd = socket.getSocketEnd();
        if (socketEnd.equals((Object)ESocketEnd.PARENT)) {
            return this.childBox;
        }
        if (socketEnd.equals((Object)ESocketEnd.CHILD)) {
            return this.parentBox;
        }
        LogUtil.logErr("Could not find complimentary socket for link: " + this.boxLink.getName() + " and socket end: " + (Object)((Object)socketEnd));
        return null;
    }

    public JointSocket getComplimentarySocket(JointSocket socket) {
        ESocketEnd socketEnd = socket.getSocketEnd();
        if (socketEnd.equals((Object)ESocketEnd.PARENT)) {
            return this.childSocket;
        }
        if (socketEnd.equals((Object)ESocketEnd.CHILD)) {
            return this.parentSocket;
        }
        LogUtil.logErr("Could not find complimentary socket for link: " + this.boxLink.getName() + " and socket end: " + (Object)((Object)socketEnd));
        return null;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof LinkBoxPair)) {
            return false;
        }
        LinkBoxPair other = (LinkBoxPair)o;
        return other.getName().equals(this.getName());
    }

    public String getName() {
        return this.boxLink.getName();
    }

    public Bearing getChildBearing() {
        return this.childBearing;
    }

    public boolean isPositioned() {
        return this.linkLineCount != null;
    }

    public void setChildBearing(Bearing childBearing) {
        this.childBearing = childBearing;
    }

    public Bearing getParentBearing() {
        return this.parentBearing;
    }

    public void setParentBearing(Bearing parentBearing) {
        this.parentBearing = parentBearing;
    }

    public BoxLink getBoxLink() {
        return this.boxLink;
    }

    public DiagramBox getChildBox() {
        return this.childBox;
    }

    public void setChildBox(DiagramBox childBox) {
        this.childBox = childBox;
    }

    public DiagramBox getParentBox() {
        return this.parentBox;
    }

    public void setParentBox(DiagramBox parentBox) {
        this.parentBox = parentBox;
    }

    public int getLinkLineCount() {
        return this.linkLineCount;
    }

    public void setLinkLineCount(int linkLineCount) {
        this.linkLineCount = linkLineCount;
    }

    public double getMiddleLineOffset() {
        return this.middleLineOffset;
    }

    public void setMiddleLineOffset(double middleLineOffset) {
        this.middleLineOffset = middleLineOffset;
    }

    public String toString() {
        return this.boxLink.getName();
    }

    public JointSocket getChildSocket() {
        return this.childSocket;
    }

    public void setChildSocket(JointSocket childSocket) {
        this.childSocket = childSocket;
    }

    public JointSocket getParentSocket() {
        return this.parentSocket;
    }

    public void setParentSocket(JointSocket parentSocket) {
        this.parentSocket = parentSocket;
    }
}

