/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.calc.edge;

import com.harrand.sketch.core.box.DiagramBox;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.Bearing;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.calc.CornerBearingEdgeRankingCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.calc.edge.IBearingEdgeCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkBoxPair;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.box.LinkedBox;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.BearingSockets;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.EdgeRanking;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.JointSocket;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.socket.comparator.DistanceSocketComparator;
import com.harrand.sketch.relation.edge.Edge;
import com.harrand.sketch.relation.edge.complimentary.TwoLineComplimentaryEdgeCalc;
import com.harrand.util.LogUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class CornerBearingEdgeCalc
implements IBearingEdgeCalc {
    private Map<Edge, Integer> interBearingCounts;
    private Bearing bearing;
    private CornerBearingEdgeRankingCalc cornerBearingEdgeRankingCalc = new CornerBearingEdgeRankingCalc();
    private int bearingSocketCount;
    private int medianPosition;
    public static final int MIDDLE_LINE_START_SPACE = 8;
    public static final int MIDDLE_LINE_GAP = 5;

    @Override
    public void updateSocketEdges(LinkedBox linkedBox, BearingSockets bearingSockets) {
        this.bearing = bearingSockets.getBearing();
        this.bearingSocketCount = bearingSockets.getSockets().size();
        this.interBearingCounts = new HashMap<Edge, Integer>();
        this.medianPosition = this.bearingSocketCount / 2;
        ArrayList<JointSocket> sockets = new ArrayList<JointSocket>(bearingSockets.getSockets());
        DistanceSocketComparator socketComparator = new DistanceSocketComparator();
        Collections.sort(sockets, socketComparator);
        int i = 0;
        boolean middleLineCount = false;
        for (JointSocket socket : sockets) {
            LinkBoxPair linkBoxPair = socket.getLinkBoxPair();
            if (!linkBoxPair.isPositioned()) {
                boolean isInFurtherHalf = this.getIsInFurtherHalf(i);
                Edge edge = this.getEdge(isInFurtherHalf);
                int bearingRank = this.cornerBearingEdgeRankingCalc.getBearingRank(this.bearing, edge);
                int interBearingRank = this.getAndIncrementInterBearingRank(edge);
                socket.setEdge(edge);
                socket.setEdgeRank(new EdgeRanking(edge, bearingRank, interBearingRank));
                JointSocket complimentarySocket = linkBoxPair.getComplimentarySocket(socket);
                Bearing complimentaryBearing = this.bearing.getComplimentary();
                DiagramBox complimentaryBox = linkBoxPair.getComplimentaryDiagramBox(socket);
                Edge complimentaryEdge = new TwoLineComplimentaryEdgeCalc().getComplimentaryEdge(edge, linkedBox.getDiagramBox().getRect(), complimentaryBox.getRect());
                complimentarySocket.setEdge(complimentaryEdge);
                linkBoxPair.setLinkLineCount(2);
                int complimentaryBearingRank = this.cornerBearingEdgeRankingCalc.getBearingRank(complimentaryBearing, complimentaryEdge);
                EdgeRanking complimentaryEdgeRanking = new EdgeRanking(complimentaryEdge, complimentaryBearingRank, interBearingRank);
                complimentarySocket.setEdgeRank(complimentaryEdgeRanking);
            }
            ++i;
        }
    }

    private Edge getEdge(boolean isInFurtherHalf) {
        if (isInFurtherHalf) {
            switch (this.bearing) {
                case NORTH_EAST: {
                    return Edge.NORTH;
                }
                case NORTH_WEST: {
                    return Edge.NORTH;
                }
                case SOUTH_EAST: {
                    return Edge.SOUTH;
                }
                case SOUTH_WEST: {
                    return Edge.SOUTH;
                }
            }
        } else {
            switch (this.bearing) {
                case NORTH_EAST: {
                    return Edge.NORTH;
                }
                case NORTH_WEST: {
                    return Edge.NORTH;
                }
                case SOUTH_EAST: {
                    return Edge.SOUTH;
                }
                case SOUTH_WEST: {
                    return Edge.SOUTH;
                }
            }
        }
        LogUtil.logErr(this.getClass().getName() + ": Could not determinE Edge for bearing: " + (Object)((Object)this.bearing));
        return null;
    }

    private boolean getIsInFurtherHalf(int internalRank) {
        int internalRankPlusOne = internalRank + 1;
        return internalRankPlusOne >= this.medianPosition;
    }

    private int getAndIncrementInterBearingRank(Edge edge) {
        if (!this.interBearingCounts.containsKey((Object)edge)) {
            this.interBearingCounts.put(edge, new Integer(0));
        }
        int currentRank = this.interBearingCounts.get((Object)edge);
        this.interBearingCounts.put(edge, currentRank + 1);
        return currentRank;
    }
}

