/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing;

import com.harrand.sketch.core.GeometryHelper;
import com.harrand.sketch.linkStrategies.RectOverlapCalc;
import com.harrand.sketch.linkStrategies.right_angle.positioner.auto.bearing.Bearing;
import com.harrand.sketch.relation.edge.Edge;
import java.awt.geom.Rectangle2D;

public final class LinkBearingCalc {
    public Bearing getRectABearing(Rectangle2D rectA, Rectangle2D rectB) {
        RectOverlapCalc rectOverlapCalc = new RectOverlapCalc();
        boolean hasOverlap = rectOverlapCalc.doCalcs(rectA, rectB);
        if (hasOverlap) {
            Edge edge = rectOverlapCalc.getEdgeA();
            Bearing bearing = Bearing.fromEdge(edge);
            return bearing;
        }
        return this.getNonOverlapBearing(rectA, rectB);
    }

    private Bearing getNonOverlapBearing(Rectangle2D rectA, Rectangle2D rectB) {
        boolean isToNorth = GeometryHelper.isRectNorth(rectA, rectB);
        Edge northSouthEdge = isToNorth ? Edge.SOUTH : Edge.NORTH;
        boolean isToWest = GeometryHelper.isRectWest(rectA, rectB);
        Edge eastWestEdge = isToWest ? Edge.EAST : Edge.WEST;
        return Bearing.fromEdges(northSouthEdge, eastWestEdge);
    }
}

